/*
 * lxcms.c
 * Author: Steve Shultz (shultzss@us.ibm.com)
 * 
 * This program provides the functions for LXCMS
 *
 * These include:
 * 	getnotes directory
 *		gets notes from partner reader and puts them in the specified directory
 * 	getrdrs directory
 *		gets non-note files from partner reader and puts them in the specified directory
 *      qrymail 
 *              lists all the files in the partner reader in a file called rdr.list
 *      selectmail file directory
 *              takes the partner reader files listed in the specified file (in rdr.list format) and places them in the specified directory
 *      removemail file 
 *              takes the partner reader files listed in the specified file (in rdr.list format) and throws them out
 *      sendnote file target
 *              creates a note from the specified file and sends it to the target
 *      CMS command
 *              executes the specified CMS command and returns the response to cmd.output 
 *      CP command
 *              executes the specified CP command and returns the response to cmd.output     
 * 	backup file filemode
 *		takes the files listed in the specified file and places them (untranslated) at the specified filemode of the partner
 * 	restore file directory
 *		takes the partner files listed in the specified file and places them (untranslated) in the specified directory
 * 	
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include "lxcms.h"

/* Global Variables */
char *password;
char userid[9];
char XPIPE_IP[16] = {0};
char XPIPE_DCSS[10] = {0};
char XPIPE_QUEUE[10] = {0};
char XPIPE_ID[9] = {0};

/* 
 * Main function
 *
 * 	Parses command line inputs and takes appropriate action
 */
main (int argc, char *argv[]){
	char command[242] = {0};
        char envbuff[242] = {0};
        char * pwbuf;
        char myblank[2] = " ";
        char sendnote[9] = "sendnote";
        char backup[7] = "backup";
        char restore[8] = "restore"; 
        char getnotes[9] = "getnotes";
        char getrdrs[8] = "getrdrs";
        char cpcmd[3] = "CP";
        char cmscmd[4] = "CMS";
        char qrymail[8] = "qrymail";
        char selmail[11] = "selectmail";
        char remmail[11] = "removemail";
                	
	int rc = RC_OK;
        int i,cmd;
        
	#ifdef DEBUG
		fprintf(stderr,"---> Enter main\n");
	#endif

        /* Set Command Value */
	if (strcmp(argv[1],getnotes)==0)
		cmd=GTN;
	else if (strcmp(argv[1],getrdrs)==0)
		cmd=GTR;
	else if (strcmp(argv[1],sendnote)==0)
		cmd=SDN;
	else if (strcmp(argv[1],backup)==0)
		cmd=BKU;
        else if (strcmp(argv[1],restore)==0)
		cmd=RST;
        else if (strcmp(argv[1],cpcmd)==0)
		cmd=CPC;
        else if (strcmp(argv[1],cmscmd)==0)
		cmd=CMS;
        else if (strcmp(argv[1],qrymail)==0)
		cmd=QRM;
        else if (strcmp(argv[1],selmail)==0)
		cmd=SLM;
        else if (strcmp(argv[1],remmail)==0)
		cmd=RMM;
        
	else {
		#ifdef DEBUG
			fprintf(stderr,"Bad Command\n");
		#endif
		rc = 8;
	}

	#ifdef DEBUG
        	fprintf(stderr,"cmd: %i\n",cmd);
        #endif 

        for (i=1; i<argc; i++)
        {
          strcat(command, argv[i]);
          strcat(command, myblank);
        }

                
        	
	#ifdef DEBUG
		fprintf(stderr,"Command: %s\n",command);
	#endif
	
	
	/* Get the Server IP address            */
	if (rc==RC_OK)
		rc = getIPaddress();

	/* Authenticate User                       */
	/* Find User Name in /proc/sysinfo  userid */
	if (rc==RC_OK){
		obtain_userid(userid);

		#ifdef DEBUG
                	fprintf(stderr,"userid: %s\n",userid);
	        #endif
              
                pwbuf = getenv("LXCMSPW");
                if (pwbuf == 0)
                {
		  /* Prompt for z/VM password 		*/
		  password = getpass("Enter password:");
                  
                }
                else password = pwbuf;
                 
                switch(cmd) 
                {                
                  case SDN:
                    memset(command, '\0', sizeof(command));
                   
                    for (i=3; i<argc; i++)
                    {
                      strcat(command, argv[i]);
                      strcat(command, myblank);
                    }
                    rc = xpgsnote(argv[2], command);
                    break;

                  case BKU:
                   
                    rc = xpgbu(argv[2], argv[3]);
                    break;
                   
                  case RST:
                   
                    rc = xpgrs(argv[2], argv[3]);
                    break;
                  
                  case GTN:
                
                    rc = xpgrdr("NOTE", argv[2]);
                    break;   
       
                  case GTR:
                
                    rc = xpgrdr("OTHR", argv[2]);
                    break;

                  case CPC:
                
                    rc = xpgcmd(command, "cmd.output");
                    break;      

                  case CMS:
                
                    rc = xpgcmd(command, "cmd.output");
                    break;

                  case QRM:
                
                    rc = xpgcmd("CMS XPQRDR", "rdr.list");
                    break; 

                  case SLM:
                
                    rc = xpgsm(argv[2], argv[3]);
                    break;

                  case RMM:
                
                    rc = xpgrm(argv[2]);
                    break; 
                
                  default:
                    break;             

                  
                }
          }
	

	#ifdef DEBUG
                fprintf(stderr,"<--- Exit main\n");
        #endif
}

int xpgrdr(char * outparm, char * target){

                int rc;
                int j,k; 
                char * colresp;
                char * justmsg;
                int numrecs;
                int totrecs;
                int datalen; 
                char allkey[2];
                char fnum[6];
                char myfilename[25];
                char keystub[16]="XPP: CMS XPRDR ";
                char displine[240]={0}; 
                
                FILE *fp;
                int opensock = 0;   

                opensock = xp_logon();
                 
                strcpy(displine, keystub);
                strcat(displine, outparm);
                rc = xp_disperse(opensock, displine, 0, 3);
                                
                colresp = xp_collect(opensock, "CLIENT:");
                if (colresp > 0)
                {
                  #ifdef DEBUG
                  fprintf(stderr,"collect response: %s\n",colresp);
                  #endif

                  justmsg = colresp + 7;
                  totrecs = atoi(justmsg);
                  free(colresp); 
                  
                  k = 0;
                  while (k < totrecs)
                  {

                    colresp = xp_collect(opensock, "CLIENT:"); /* get file name to use */

                    #ifdef DEBUG
                    fprintf(stderr,"collect response: %s\n",colresp);
                    #endif

                    k++;
                    justmsg = colresp +7;

                    memset(myfilename, '\0', sizeof(myfilename));
                   
                    if (strcmp(".",target)!=0);
                    {
                      strcat(myfilename, target);
                      strcat(myfilename, "/");
                    }

                    strcat(myfilename, justmsg);
                    free(colresp);
                    
                    colresp = xp_collect(opensock, "CLIENT:");

                    #ifdef DEBUG
                    fprintf(stderr,"collect response: %s\n",colresp);
                    #endif

                    k++;
                    justmsg = colresp +7;
                    numrecs = atoi(justmsg);
                    free(colresp);
                    j = 0;
                                        
                    if ((fp = fopen(myfilename, "w"))==NULL) j = numrecs;
                    
                    while ( j < numrecs)
                    {
                      colresp = xp_collect(opensock, "CLIENT:");

                      #ifdef DEBUG
                      fprintf(stderr,"collect response: %s\n",colresp);
                      #endif

                      justmsg = colresp +7;
                      k++;
                      j++;
                      /* write to file */
                      
	              datalen = strlen(justmsg);
	              justmsg[datalen]='\n';
          	      fputs(justmsg,fp);
		        
	              free(colresp);
                    }
                    
                    fclose(fp);
                  }
                  	
		}
				
		close(opensock);		
	        return rc;
}
	
int xpgcmd(char * mycmd, char * outfile){

                int rc;
                int k; 
                char * colresp;
                char * justmsg;
                int totrecs;
                int datalen; 
                char wholecmd[246] = {0}; 
                char justkey[5]="XPP:";
                                
                FILE *fp;
                int opensock = 0;   

                opensock = xp_logon();
                strcpy(wholecmd, justkey);
                strcat(wholecmd, mycmd);
                rc = xp_disperse(opensock, wholecmd, 0, 3);
                
                if (outfile != 0)
                {
                  colresp = xp_collect(opensock, "CLIENT:");
                  if (colresp > 0)
                  {
                  
                    #ifdef DEBUG
                    fprintf(stderr,"collect response: %s\n",colresp);
                    #endif  

                    justmsg = colresp + 7;
                    totrecs = atoi(justmsg);
                    free(colresp);
                                    
                    if ((fp = fopen(outfile, "w"))==NULL) return 8;
                    else
                    {

                      k = 0;
                  
                      while (k < totrecs)
                      {
                        colresp = xp_collect(opensock, "CLIENT:");

                        #ifdef DEBUG
                        fprintf(stderr,"collect response: %s\n",colresp);
                        #endif

                        k++;
                        justmsg = colresp +7;
                      
                        /* write to file */
                      
	                datalen = strlen(justmsg);
	                justmsg[datalen]='\n';
          	        fputs(justmsg,fp);
		        
	                free(colresp);
                      } /* done processing output */
                    
                      fclose(fp);
                    } /* done with output file */
                  	
		  } /* done checking for a response */
                } /* done checking for output file */
				
		close(opensock);		
	        return rc;
}

int xpgsnote(char * infname, char * inuser){

                int rc;
                int i,k; 
                char * colresp;
                char * justmsg;
                int totrecs;
                int datalen; 
                char wholecmd[246] = {0}; 
                char displine[246] = {0}; 
                char keystub[17]="XPP:CMS XPSNOTE ";
                char justkey[5]="XPP:";
                                 
                FILE *fp;
                int opensock = 0;
                i = 0;   

                opensock = xp_logon();
                strcpy(wholecmd, keystub);
                strcat(wholecmd, inuser);
                rc = xp_disperse(opensock, wholecmd, 0, 3); /* tell partner we're sending them something */
                memset(wholecmd, '\0', sizeof(wholecmd));
                if ((fp = fopen(infname, "r"))==NULL) return 8;
                else
                {
                  while(fgets(wholecmd,200,fp) != NULL) i++; /* count the lines */
                  fclose(fp);
                  memset(wholecmd, '\0', sizeof(wholecmd));
                  sprintf(wholecmd, "XPP:%d", i);
                  rc = xp_disperse(opensock, wholecmd, 0, 3); /* send line count */
                }
                if ((fp = fopen(infname, "r"))==NULL) return 8;
                else
                {
                  memset(wholecmd, '\0', sizeof(wholecmd));
                  memset(displine, '\0', sizeof(displine));
                  strcat(displine, justkey); 
		  while(fgets(wholecmd,200,fp) != NULL) /* send all the data */
                  {
                    strcat(displine, wholecmd);
                    rc = xp_disperse(opensock, displine, 0, 3);
                    memset(wholecmd, '\0', sizeof(wholecmd));
                    memset(displine, '\0', sizeof(displine));
                    strcat(displine, justkey); 
			
		  }
                  fclose(fp);
		}
                                
                colresp = xp_collect(opensock, "CLIENT:");
                if (colresp > 0)
                { 

                  #ifdef DEBUG
                  fprintf(stderr,"collect response: %s\n",colresp);
                  #endif

                  justmsg = colresp + 7;
                  totrecs = atoi(justmsg);
                  free(colresp); 
                  
                  k = 0;
                  
                  while (k < totrecs)
                  {
                      colresp = xp_collect(opensock, "CLIENT:");

                      #ifdef DEBUG
                      fprintf(stderr,"collect response: %s\n",colresp);
                      #endif

                      k++;
                      		        
	              free(colresp);
                  }
                                      
                  	
		}
		
                close(opensock);				
	        return rc;
}

int xpgbu(char * infname, char * target){

                int rc;
                int fnamelen;
                int i,j,k; 
                char * colresp;
                char * justmsg;
                int totrecs;
                int datalen; 
                char wholecmd[246] = {0}; 
                char displine[246] = {0}; 
                char contents[246] = {0}; 
                char dispcont[246] = {0}; 
                char keystub[14]="XPP:CMS XPBU ";
                char justkey[5]="XPP:";
                                 
                FILE *fp;
                FILE *fq;
                int opensock = 0;
                i = 0;   

                opensock = xp_logon();
                strcpy(wholecmd, keystub);
                strcat(wholecmd, target);
                rc = xp_disperse(opensock, wholecmd, 0, 3); /* tell partner we're sending them something */
                memset(wholecmd, '\0', sizeof(wholecmd));
                if ((fp = fopen(infname, "r"))==NULL) return 8;
                else
                {
                  while(fgets(wholecmd,200,fp) != NULL) i++; /* count the files */
                  fclose(fp);
                  memset(wholecmd, '\0', sizeof(wholecmd));
                  sprintf(wholecmd, "XPP:%d", i);
                  rc = xp_disperse(opensock, wholecmd, 0, 3); /* tell partner how many files */
                }
                if ((fp = fopen(infname, "r"))==NULL) return 8;
                else
                {
                  memset(wholecmd, '\0', sizeof(wholecmd));
                  memset(displine, '\0', sizeof(displine));
                  strcat(displine, justkey); 
		  while(fgets(wholecmd,200,fp) != NULL) /* send the name of each file and its contents */
                  {
                    strcat(displine, wholecmd);
                    rc = xp_disperse(opensock, displine, 0, 3);

                    /* send contents here */
                    fnamelen = strlen(wholecmd) - 1;
                    wholecmd[fnamelen] = 0x00;
                    if ((fq = fopen(wholecmd, "r"))==NULL) return 8;
                    else
                    {
                      j = 0;
                      while(fgets(contents,200,fq) != NULL) j++; /* count the records */
                      fclose(fq);
                      memset(contents, '\0', sizeof(contents));
                      sprintf(contents, "XPP:%d", j);
                      rc = xp_disperse(opensock, contents, 0, 3); /* tell partner how many records */
                    }
                    if ((fq = fopen(wholecmd, "r"))==NULL) return 8;
                    else
                    {
                      memset(contents, '\0', sizeof(contents));
                      memset(dispcont, '\0', sizeof(dispcont));
                      strcat(dispcont, justkey); 
		      while(fgets(contents,200,fq) != NULL) /* send the name of each file and its contents */
                      {
                        strcat(dispcont, contents);
                        rc = xp_disperse(opensock, dispcont, 0, 3);
                    
                        memset(contents, '\0', sizeof(contents));
                        memset(dispcont, '\0', sizeof(dispcont));
                        strcat(dispcont, justkey); 
			
		      }
                      fclose(fq);
		    }

                    memset(wholecmd, '\0', sizeof(wholecmd));
                    memset(displine, '\0', sizeof(displine));
                    strcat(displine, justkey); 
			
		  }
                  fclose(fp);
		}
                                
                colresp = xp_collect(opensock, "CLIENT:");
                if (colresp > 0)
                {

                  #ifdef DEBUG
                  fprintf(stderr,"collect response: %s\n",colresp);
                  #endif

                  justmsg = colresp + 7;
                  totrecs = atoi(justmsg);
                  free(colresp); 
                  
                  k = 0;
                  
                  while (k < totrecs)
                  {
                      colresp = xp_collect(opensock, "CLIENT:");

                      #ifdef DEBUG
                      fprintf(stderr,"collect response: %s\n",colresp);
                      #endif

                      k++;
                      		        
	              free(colresp);
                  }
                                      
                  	
		}
				
		close(opensock);		
	        return rc;
}

int xpgrs(char * infname, char * target){

                int rc;
                int i,j,k; 
                char * colresp;
                char * justmsg;
                int totrecs;
                int datalen; 
                char wholecmd[246] = {0}; 
                char displine[246] = {0}; 
                char outfilen[246];
                char keystub[13]="XPP:CMS XPRS";
                char justkey[5]="XPP:";
                int alldone = 0;
                                 
                FILE *fp;
                int opensock = 0;
                i = 0;   

                opensock = xp_logon();
                strcpy(wholecmd, keystub);
                
                rc = xp_disperse(opensock, wholecmd, 0, 3); /* tell partner we're sending them something */
                memset(wholecmd, '\0', sizeof(wholecmd));
                if ((fp = fopen(infname, "r"))==NULL) return 8;
                else
                {
                  while(fgets(wholecmd,200,fp) != NULL) i++; /* count the lines */
                  fclose(fp);
                  memset(wholecmd, '\0', sizeof(wholecmd));
                  sprintf(wholecmd, "XPP:%d", i);
                  rc = xp_disperse(opensock, wholecmd, 0, 3); /* send line count */
                }
                if ((fp = fopen(infname, "r"))==NULL) return 8;
                else
                {
                  memset(wholecmd, '\0', sizeof(wholecmd));
                  memset(displine, '\0', sizeof(displine));
                  strcat(displine, justkey); 
		  while(fgets(wholecmd,200,fp) != NULL) /* send all the data */
                  {
                    strcat(displine, wholecmd);
                    rc = xp_disperse(opensock, displine, 0, 3);
                    memset(wholecmd, '\0', sizeof(wholecmd));
                    memset(displine, '\0', sizeof(displine));
                    strcat(displine, justkey); 
			
		  }
                  fclose(fp);
		}

                /* loop thru all the files */
                j = 0;

                while (j < i)
                {
                  memset(outfilen, '\0', sizeof(outfilen));
                  colresp = xp_collect(opensock, "CLIENT:");
                 
                  #ifdef DEBUG
                  fprintf(stderr,"collect response: %s\n",colresp);
                  #endif

                  j++;

                  if (colresp > 0)
                  {
                    if (strcmp(".",target)==0) strcat(outfilen, colresp + 7);
                    else
                    {
                      strcpy(outfilen, target);
                      strcat(outfilen, "/");
                      strcat(outfilen, colresp + 7);
                    }
                    
                    
                    free(colresp);
                    if ((fp = fopen(outfilen, "w"))==NULL) return 8;
                    else
                    {
                      colresp = xp_collect(opensock, "CLIENT:");
                  
                      #ifdef DEBUG
                      fprintf(stderr,"collect response: %s\n",colresp);
                      #endif

                      justmsg = colresp + 7;
                      totrecs = atoi(justmsg);
                      free(colresp); 

                      k = 0;
                  
                      while (k < totrecs)
                      {
                        colresp = xp_collect(opensock, "CLIENT:");

                        #ifdef DEBUG
                        fprintf(stderr,"collect response: %s\n",colresp);
                        #endif

                        k++;
                        justmsg = colresp +7;
                      
                        /* write to file */
                  	                
          	        fputs(justmsg,fp);
		        
	                free(colresp);
                      }
                    
                      fclose(fp);
                    }
                                         
                  	
		  }

                }
                colresp = xp_collect(opensock, "CLIENT:");
                if (colresp > 0)
                {

                  #ifdef DEBUG
                  fprintf(stderr,"collect response: %s\n",colresp);
                  #endif

                  justmsg = colresp + 7;
                  totrecs = atoi(justmsg);
                  free(colresp); 
                  
                  k = 0;
                  
                  while (k < totrecs)
                  {
                      colresp = xp_collect(opensock, "CLIENT:");

                      #ifdef DEBUG
                      fprintf(stderr,"collect response: %s\n",colresp);
                      #endif

                      k++;
                      		        
	              free(colresp);
                  }
                                      
                  	
		}
		
                close(opensock);				
	        return rc;
}

int xpgsm(char * infname, char * target){

                int rc;
                int j,k; 
                char * colresp;
                char * justmsg;
                int totrecs;
                int datalen; 
                char wholecmd[246] = {0}; 
                                                 
                FILE *fp;
                                
                if ((fp = fopen(infname, "r"))==NULL) return 8;
                else
                {
                  memset(wholecmd, '\0', sizeof(wholecmd));
                  while(fgets(wholecmd,200,fp) != NULL) /* send all the data */
                  {
                    rc = xpgrdr(wholecmd, target);
                    memset(wholecmd, '\0', sizeof(wholecmd));
                    			
		  }
                  fclose(fp);
		}
                return rc;
}

int xpgrm(char * infname){

                int rc;
                int j,k; 
                char * colresp;
                char * justmsg;
                int totrecs;
                int datalen; 
                char wholecmd[246] = {0};
                char cmdstub[10]="CMS XPRM ";
                                                                 
                FILE *fp;
                                
                if ((fp = fopen(infname, "r"))==NULL) return 8;
                else
                {
                  memset(wholecmd, '\0', sizeof(wholecmd));
                  strcpy(wholecmd, cmdstub);
                  while(fgets(wholecmd + 9,200,fp) != NULL) /* send all the data */
                  {
                    rc = xpgcmd(wholecmd, 0);
                    memset(wholecmd, '\0', sizeof(wholecmd));
                    strcpy(wholecmd, cmdstub);
                    			
		  }
                  fclose(fp);
		}
                return rc;
}

/**
 * getIPaddress
 *
 * 	Get the server ip address from the config file.
 *
 */
int getIPaddress(){
	int rc = RC_OK;
        int found = 0;
        int namelen;
	FILE *fp;
	char line[81];
	char tag[9]="XPIPE_IP";
        char tag2[11]="XPIPE_DCSS";
        char tag3[12]="XPIPE_QUEUE";
        char tag4[9]="XPIPE_ID"; 

	#ifdef DEBUG
                fprintf(stderr,"---> Enter getIPaddress\n");
        #endif

	/* Open the config file, fail if it does not exist */
	if((fp = fopen(CONFIGFILE, "r"))==NULL){
		rc = 8;
	} else {
		/* Get a line from the config file */
		while(fgets(line,80,fp) != NULL){
			/* Compare the line to the tag */
			if(strncmp(tag,line,8)==0){
				strcpy(XPIPE_IP,line+9);
                                namelen = strlen(XPIPE_IP) - 1;
                                XPIPE_IP[namelen]='\0'; /* get rid of line feed */ 
                                found = found + 1;
                        	
			}
                        if(strncmp(tag2,line,10)==0){
				strcpy(XPIPE_DCSS,line+11);
                                namelen = strlen(XPIPE_DCSS) - 1;
                                XPIPE_DCSS[namelen]='\0'; /* get rid of line feed */
                                found = found + 1;
                        	
			}
                        if(strncmp(tag3,line,11)==0){
				strcpy(XPIPE_QUEUE,line+12);
                                namelen = strlen(XPIPE_QUEUE) - 1;
                                XPIPE_QUEUE[namelen]='\0'; /* get rid of line feed */
                                found = found + 1;
                        	
			}
                        if(strncmp(tag4,line,8)==0){
				strcpy(XPIPE_ID,line+9);
                                namelen = strlen(XPIPE_ID) - 1;
                                XPIPE_ID[namelen]='\0'; /* get rid of line feed */
                                                        	
			}
		}

		/* Close the files */
		fclose(fp);

	}
	
	/* Check if we found the IP address */
	if (found<3){
		rc = 8;
		#ifdef DEBUG
			fprintf(stderr,"Could not find the IP address\n");
		#endif
	}

	#ifdef DEBUG
                fprintf(stderr,"<--- Exit getIPaddress\n");
        #endif
return rc;
}


/*
 * obtain_userid
 * 
 *	Determine the user id that we are executing from
 * @return userid	
 **/
void obtain_userid(char *name)
{
	FILE *sysinfo;
	char fileline[100];
	char *line;
	char keyword[10] = {"VM00 Name:"};

	#ifdef DEBUG
                fprintf(stderr,"---> Enter obtain_userid\n");
        #endif

        if (strcmp("",XPIPE_ID)==0)
        {
     
  	  /* open the sysinfo file */
	  sysinfo = fopen("/proc/sysinfo", "r");

	  /* Find the VM Name Line and copy the name */
	  do {
		line = fgets(fileline, 100, sysinfo);  

		if (line != NULL) {
			if (strncmp(line,keyword, 10) == 0){
				line+=22;
				strncpy(name,line,8);
			}
		}
          } while (line != NULL);
	
	  /* Append a null terminator */
	  name[9]= '\0';	

	  /* Close the file */
	  fclose(sysinfo);
        }
        else strcpy(name,XPIPE_ID);   

	#ifdef DEBUG
                fprintf(stderr,"<--- Exit obtain_userid\n");
        #endif
}

/*
 * append_buffer
 * 	
 * 	Append NULL terminated strings to a parameter buffer
 *
 * @param buffer_ptr	Pointer to the current position in the buffer
 * @param src		String to be appended
 * @param buffer_size	Current size of the buffer
 **/
void append_buffer(char *buffer_ptr, char *src, int *buffer_size)
{
	int src_size;
	
	/* Determine the size of the source */
	src_size = strlen(src) + 1;
	
	/* Copy the src to the destination */
	memcpy(buffer_ptr, src, src_size);

	/* Increment the buffer pointer */
	buffer_ptr += src_size;

	/* Increment the buffer size */
	*buffer_size += src_size;

	#ifdef DEBUG
                fprintf(stderr,"In append_buffer.  Appended: %s\n",src);
        #endif
}
	

/*
 * xp logon
 * 
 * 	logon to xpipe server
 *
 *
 **/
int xp_logon()
{
	int fd;
 	char buffer[MAX_BUFFER_SIZE+1]={0};
	struct sockaddr_in servaddr;
        int buffer_size = 4;
        int data_size;
        int rc; 
        char *buffer_ptr;
        char *colresp;  

        buffer_ptr = buffer;
	
	#ifdef DEBUG
                fprintf(stderr,"---> Enter xp_logon\n");
		
	#endif

        
        /* Create Socket */
	fd = socket(AF_INET, SOCK_STREAM, 0);
	
	  if (fd<0){
		#ifdef DEBUG
			fprintf(stderr, "socket() failed\n");
		#endif
		
	  } else { /* socket worked */
		#ifdef DEBUG
			fprintf(stderr,"socket created\n");
		#endif

		/* Set up the sockaddr */
		memset(&servaddr, 0, sizeof(servaddr));
        	servaddr.sin_family = AF_INET;
        	servaddr.sin_port = htons(XPIPE_PORT);
        	servaddr.sin_addr.s_addr = inet_addr(XPIPE_IP);
	
		/* Connect to the xpipe Server */
		rc = connect(fd,(struct sockaddr *)&servaddr, sizeof(servaddr));
		if (rc<0){
                	#ifdef DEBUG
                        	fprintf(stderr, "connect() failed %i\n", rc);
                	#endif
                	fd = rc;
        	} else { /* Connect Worked */
			#ifdef DEBUG
	                        fprintf(stderr,"socket connected\n");
        	        #endif
                        
                        /* build logon buffer */

                        /* Append userid */
	                append_buffer(buffer+buffer_size, userid, &buffer_size);		

	                /* Append Password to the parameter list */
	                append_buffer(buffer+buffer_size, password, &buffer_size);

                        /* Append dcss name to the parameter list */
	                append_buffer(buffer+buffer_size, XPIPE_DCSS, &buffer_size);

                        data_size = buffer_size - 4;

                        memcpy(buffer_ptr, &data_size, 4);

                        /* Send the XPIPE Call */
			rc = send(fd, buffer, buffer_size, 0);

			if (rc<0){
                		#ifdef DEBUG
                        		fprintf(stderr, "send() failed\n");
                		#endif
                		fd = rc;
        		} 
	                
                        rc = xp_disperse(fd, "SCLEAN", 0, 6);
                        colresp = xp_collect(fd, "ECLEAN");
                        free(colresp);
				
		} /* End Connect Worked */
	} /* End Socket Worked */ 

	
	
	#ifdef DEBUG
                fprintf(stderr,"<--- Exit xp_logon\n");
        #endif

return fd;
}


/*
 * xp disperse
 * 
 * 	disperse data onto the shared queue
 *
 *
 **/
int xp_disperse(int fd, char *mydata, int keyoff, int keylen)
{
	
        int buffer_size = 4;
        int data_size;
        int rc = 0; 
        char *buffer_ptr;
        char buffer[MAX_BUFFER_SIZE+1]={0}; 
        char offbuff[11]={0}; 
        char lenbuff[11]={0};

        buffer_ptr = buffer;
	
	#ifdef DEBUG
                fprintf(stderr,"---> Enter xp_disperse\n");
		
	#endif

        /* create key offset and length strings */ 
        
        sprintf(offbuff, "%d", keyoff);
        sprintf(lenbuff, "%d", keylen);
        
        
                        
        /* build disperse buffer */

        /* Append disperse command */
        append_buffer(buffer+buffer_size, DISPERSE, &buffer_size);		

        /* Append appropriate queue */
        append_buffer(buffer+buffer_size, XPIPE_QUEUE, &buffer_size);

        /* Append key offset */
        append_buffer(buffer+buffer_size, offbuff, &buffer_size);

        /* Append key length */
        append_buffer(buffer+buffer_size, lenbuff, &buffer_size);

        /* Append data */
        append_buffer(buffer+buffer_size, mydata, &buffer_size);

        data_size = buffer_size - 4;

        memcpy(buffer_ptr, &data_size, 4);

        /* Send the XPIPE Call */
	rc = send(fd, buffer, buffer_size, 0);

	if (rc<0){
        	#ifdef DEBUG
        	        fprintf(stderr, "send() failed\n");
        	#endif
                		
        } 
					
		
	#ifdef DEBUG
                fprintf(stderr,"<--- Exit xp_disperse\n");
        #endif

return rc;
}


/*
 * xp collect
 * 
 * 	collect data from the shared queue
 *
 *
 **/
char * xp_collect(int fd, char *mykey)
{
	
        int buffer_size = 4;
        int data_size;
        int *readlenp;
        int readlen; 
        int rc = 0;
        int bytes_read;
        int i;
        int baddata = 0; 
        char *buffer_ptr;
        int total_bytes=0;
        char buffer[MAX_BUFFER_SIZE+1]={0};
        char len_buffer[4]={0}; 
        char * read_buffer;
      
        buffer_ptr = buffer;
	
	#ifdef DEBUG
                fprintf(stderr,"---> Enter xp_collect\n");
		
	#endif

                                
        /* build collect buffer */

        /* Append collect command */
        append_buffer(buffer+buffer_size, COLLECT, &buffer_size);		

        /* Append appropriate queue */
        append_buffer(buffer+buffer_size, XPIPE_QUEUE, &buffer_size);

        /* Append key */
        append_buffer(buffer+buffer_size, mykey, &buffer_size);

        /* Append timeout */
        append_buffer(buffer+buffer_size, XPIPE_TO, &buffer_size);

        /* Append timeout data */
        append_buffer(buffer+buffer_size, XPIPE_TOMSG, &buffer_size);

        data_size = buffer_size - 4;

        memcpy(buffer_ptr, &data_size, 4);

        /* Send the XPIPE Call */
	rc = send(fd, buffer, buffer_size, 0);

	if (rc<0){
        	#ifdef DEBUG
        	        fprintf(stderr, "send() failed\n");
        	#endif
                		
        
        } else { /* Send Worked */
		#ifdef DEBUG
	                 fprintf(stderr,"data sent on socket\n");
        	#endif

		/* Read the response */
                
                total_bytes = 0;
		rc = 0;
		while ((total_bytes < 4) && (baddata == 0)) {
		        #ifdef DEBUG
                		fprintf(stderr,"reading length of data\n");
		        #endif
			bytes_read = read(fd, len_buffer + total_bytes, 4 - total_bytes);

			
			/* If there was data and readdone!=0 */
			if (bytes_read > 0){
                 		
				total_bytes+=bytes_read;
			} else
				baddata = 1;		/* There was no data or read done */
						
		} /* End while more to read */
		
		#ifdef DEBUG
			fprintf(stderr,"total_bytes: %i\n",total_bytes);
			fprintf(stderr,"len Buffer: \n");
       			for(i=0; i < total_bytes; i++)
	                        fputc(len_buffer[i], stderr);
	                fprintf(stderr,"\n");

		#endif

                readlenp = (int *)&len_buffer;
                readlen = *readlenp;
                read_buffer = malloc(readlen + 2);
                memset(read_buffer, '\0', readlen + 2);
                total_bytes = 0;
                if (read_buffer == 0) baddata = 1;
                 
                while ((total_bytes < readlen) && (baddata == 0)) {
		        #ifdef DEBUG
                		fprintf(stderr,"reading length of data\n");
		        #endif
			bytes_read = read(fd, read_buffer + total_bytes, readlen - total_bytes);

			#ifdef DEBUG
				fprintf(stderr,"%i bytes read: readbuffer: ",bytes_read);
				for(i=0; i<bytes_read; i++)	
					fputc(read_buffer[i], stderr);
				fprintf(stderr,"\n");
			#endif

			/* If there was data and readdone!=0 */
			if (bytes_read > 0){
                 		
				total_bytes+=bytes_read;
			} else
				baddata = 1;		/* There was no data or read done */
						
		} /* End while more to read */
                
                #ifdef DEBUG
			fprintf(stderr,"total_bytes: %i\n",total_bytes);
			fprintf(stderr,"read Buffer: \n");
       			for(i=0; i < total_bytes; i++)
	                        fputc(read_buffer[i], stderr);
	                fprintf(stderr,"\n");

		#endif	
		if ((baddata == 1) && (read_buffer > 0))
                {
                   free(read_buffer);
                   read_buffer = 0;
                }  							
		
	#ifdef DEBUG
                fprintf(stderr,"<--- Exit xp_collect\n");
        #endif
        } /* end send worked */

return read_buffer;
}


