// Highlight the element
function highlightDiv(div)
{
	div.style.backgroundColor = "#E0F2FF"
/*	if(div.className.indexOf(" groupHighlightRow") == -1)
		div.className += " groupHighlightRow"*/
}

// Unhighlight the element
function unhighlightDiv(div)
{
	div.style.backgroundColor = "#FFFFFF"

	/*name = div.className
	name.replace(/groupHighlightRow/, "")
	alert(name)
	div.className = name*/
}



/**
 * Opens a node if it's closed, closes a node if it's open.
 * Records the transformation in a cookie.
 * 
 * @param handle The node to open or close. this can be either
 *               the UL[treenode] element itself (presumably) or
 *               (what it was intended for) the text/image combo
 *               that registers a click.
 */
function toggleNodeVisibility(handle)
{
	// handle is a node with ID "(groupName)Handle"
	var nodeId = handle.id.replace(/Handle/,"")
	
	// we want the UL that corresponds to collapse; it has 
	// ID of just "(groupName)"
	var node = document.getElementById(nodeId)
	
	// finally, we'll need to swap the plus/minus
	var image = document.getElementById(nodeId + "Picture")
	
	if(node.style.display == "none")
	{
		var groups = getOpenCookieGroups()
		groups = addToArray(groups,nodeId)
		setOpenCookieGroups(groups)
		
		node.style.display = "block"
		image.src = "/live/resources/minus.gif"
		image.alt = "Collapse group " + nodeId
	}
	else
	{
		var groups = getOpenCookieGroups()
		groups = removeFromArray(groups, nodeId)
		setOpenCookieGroups(groups)
		
		node.style.display = "none"
		image.src = "/live/resources/plus.gif"
		image.alt = "Expand group " + nodeId
	}
}

/**
 * This function unconditionally collapses the node specified. It DOES NOT remove
 * that group from the cookie that says what groups are open!
 * 
 * @param handle The node to collapse, as specificed in toggleNodeVisibility(handle)
 */
function collapseNode(handle)
{
	var nodeId = handle.id.replace(/Handle/,"")
	var node = document.getElementById(nodeId)
	var image = document.getElementById(nodeId + "Picture")
	
	node.style.display = "none"
	image.src = "/live/resources/plus.gif"
	image.alt = "Expand group " + nodeId
}

/**
 * This collapses all groups
 */
function collapseAllGroups()
{
	var potentialGroupSpots = document.getElementsByTagName("ul")
	
	for(var i=0 ; i<potentialGroupSpots.length ; ++i)
	{
		// FIXME: if a classname has treenode as a substring, this if could 
		//        pass without you wanting it to
		if(potentialGroupSpots[i].className.indexOf("treenode") != -1)
		{
			var handle = document.getElementById(potentialGroupSpots[i].id + "Handle")
			collapseNode(handle)
			
			// This function is also used for setup, and we set onclick to
			// toggle the tree.
			handle.onclick = function(event)    { toggleNodeVisibility(this) }
			
			var handle = document.getElementById(potentialGroupSpots[i].id + "Div")
			handle.onmouseout  = function(event) { unhighlightDiv(this) }
			handle.onmouseover = function(event) { highlightDiv(this) }
		}
	}
	
	// Again, this function is also used for setup. This line tells the browser
	// to detach the onclick handlers when the document is unloaded. See the function
	// comment why this is necessary
	window.onunload = unloadTreeNodeClickHandlers
}


// This function shouldn't be necessary. In an ideal implementation, it would'nt be.
// However, at least IE may have a massive memory leak if this isn't done. The problem
// is that DOM objects and Javascript objects have different garbage collectors. 
// Javascript uses reference counting with cycle detection, the DOM uses a mark and
// sweep style GC. However, if there is a Javascript object that holds reference to a DOM
// object that holds reference to a Javascript object (e.g. the onclick handler) then
// both GCs break and nothing (involved) is collected. This function hopefully breaks
// any cycles that might have been formed.
//
// At this point too, Javascript shouldn't be holding any references to DOM objects so
// even as such it shouldn't be necessary, but it's here as a future-proofing.
function unloadTreeNodeClickHandlers()
{
	var potentialGroupSpots = document.getElementsByTagName("ul")
	
	for(var i=0 ; i<potentialGroupSpots.length ; ++i)
	{
		if(potentialGroupSpots[i].className == "treenode")
		{
			var handle = document.getElementById(potentialGroupSpots[i].id + "Handle")
			handle.onclick = null
			handle.onmouseout = null
			handle.onmouseover = null
		}
	}
}

// This function toggles the visibility of all the groups that are named in the
// OpenGroups cookie. It's intended to be used on page load right after
// collapseAllGroups, so in effect it opens them.
function openCookieGroups()
{
	var groups = getOpenCookieGroups()

	if(groups == null) 
		return;
	
	for(var i=0 ; i<groups.length ; ++i)
	{
		var handle = document.getElementById(groups[i] + "Handle")
		toggleNodeVisibility(handle)
	}
}
		
// This function returns an array of all the names in the cookie OpenGroups.
// This cookie has the format Group1|Group2|...|Groupn
function getOpenCookieGroups()
{
	var cookie = unescape(cookieValue("OpenGroups"))
	if(cookie == "null") return new Array(0)
	var groups = cookie.split('|')
	if(groups == null) return new Array(0)
	return groups
}

// This function sets the OpenGroups cookie so that the groups in the array
// groups are named. Again, the format is Group1|Group2|...|Groupn
function setOpenCookieGroups(groups)
{
	if(groups.length != 0)
	{
		var cookie = ""
		
		for(i=0 ; i<groups.length ; ++i)
		{
			if(groups[i] == "null")
				continue
			
			cookie += groups[i]
			
			if(i != groups.length-1)
				cookie += '|'
		}
		
		cookie = escape(cookie)
		
		document.cookie = "OpenGroups=" + cookie	
	}
	else
	{
		// There are no groups, so we want to clear the cookie
		document.cookie = "OpenGroups=none;expires=Sat, 1 Jan 2000 00:00:01 UTC"
	}
}

