// This file is for the pages that need the guest list with checkboxes and
// radio buttons, e.g. new group & new network


// This is called if a group node is clicked. It searches through all INPUT
// tags to see if the group name is in the ID. If so, that box is a guest
// and it's checked property is set to the same as the node that was clicked.
function turnOnChildren(parent)
{
	var potentialChildren = document.getElementsByTagName("input")
	var parentGroupName = "GUEST_" + parent.id.replace(/GROUP_/, "") + "_"
	
	for(var i=0 ; i<potentialChildren.length ; ++i)
	{
		if(potentialChildren[i].id.indexOf(parentGroupName) == 0)
			potentialChildren[i].checked = parent.checked
	}
}

// This goes through the tree and, for each group checkbox:
// 1. if deattach (yeah yeah) is true, sets onclick to null (see
//    guestListPage.js unloadTreeNodeClickHandlers() for an explanation)
// 2. if deattach is false, sets onclick to turnOnChildren for that node
function setTurnOnChildrenHandlers(deattach)
{
	var potentialParents = document.getElementsByTagName("input")

	for(var i=0 ; i<potentialParents.length ; ++i)
	{
		if(potentialParents[i].id.indexOf("GROUP_") == 0)
		{
			if(deattach)
			{
				potentialParents[i].onclick = null
			}
			else
			{
				potentialParents[i].onclick = function(owner)
					{ turnOnChildren(this) }
			}
		}
	}
	
	document.onunload = function() { attachTurnOnChildrenHandlers(true) }
}

function attachTurnOnChildrenHandlers()
{	setTurnOnChildrenHandlers(false) }
