// This function copies array, with the exception that the copy does not include
// key if it is present in the original array, then returns the copy.
//
// Combined with addToArray(array, key), this allows you to easily use an array
// as a set.
function removeFromArray(array, key)
{
	var ret = new Array(0)
	for(var i=0 ; i<array.length ; ++i)
	{
		if(array[i] != key)
			ret.push(array[i])
	}
	
	return ret;
}

// This function adds key to array if it is not already present. I'm not sure if
// Javascript is using references or actual objects. If it does, array is also modified
// (no copy is made as in removeFromArray). To be sure, array is returned anyway.
function addToArray(array, key)
{
	for(var i=0 ; i<array.length ; ++i)
	{
		if(array[i] == key)
			return array;
	}
	
	array.push(key)
	
	return array;
}

// This function I don't think is ever used, but it checks the two input tags whose
// IDs are passed in as id1 and id2 to see if they are the same. If they aren't,
// it displays the element whose ID is error. It then sets the onkeypress events of
// id1 and id2 to the function shade, which doesn't appear to exist in here.
function checkConfirmPassword(id1, id2, error, shade)
{
	var pass = document.getElementById(id1)
	var conf = document.getElementById(id2)
	
	// TODO; do insensitive compare
	if(pass.value != conf.value)
	{
		var err = document.getElementById(error)
		
		err.style.display = "block"
		err.style.color = "red"
		
		conf.style.backgroundColor = "#ff6666";
		conf.onkeypress = shade
		
		pass.onkeypress = shade
		
		return false;
	}
	return true;
}

// This function colors form errors appropriately.
function shadeError(msgid, fieldid)
{
	var msg   = document.getElementById(msgid)
	var field = document.getElementById(fieldid)
	
	field.style.backgroundColor = "#E0E0E0"
	msg.style.color = "#A8A8A8"
}

// This function takes a string str and removes all leading and trailing spaces.
// Nothing is returned.
function trim(str)
{
	// Regular expression explanation:
	//   ^\s+   Beginning of the string (/^), then one or more (+) whitespace (\s),
	//      |    or
	//   \s+$   One or more whitespace characters, then the end of the string
	str.replace(/^\s+|\s+$/g, "");
}

// This function looks at all the cookies set for the current site for a cookie
// with the name key. If it finds it, cookieValue returns its value. Otherwise it
// returns null.
//
// (One site can have several cookies stored. Each cookie has the form key=value.
//  It's only possible (through Javascript) to get access to all the cookies at
//  once in the form cookie1;cookie2;...;cookieN (so key=value;key=value;...),
//  so we have to break it apart manually if we want a specific cookie.)
function cookieValue(key)
{
	var pairs = document.cookie.split(";")
	var keylen = key.length
	
	for(var i=0 ; i<pairs.length ; ++i)
	{
		pairs[i] = pairs[i].replace(/^(\s+)?(.*\S)(\s+)?$/, '$2')

		var thispair = pairs[i].split("=")
		if(thispair[0] == key)
		{
			return thispair[1]
		}
	}
	
	return null;
}


// Opens a window with width width, height height, and url url
function popupRemote(url, width, height)
{
	var remoteWidth  = width
	var remoteHeight = height
	
	// We want to center the popup, so we have to get the 
	// browser's width and height
	
	// Mozilla code
	var browserW = window.outerWidth
	var browserH = window.outerHeight
	
	// IE code
	if(!browserW || !browserH)
	{
		browserW = document.body.offsetWidth
		browserH = document.body.offsetHeight
	}
	
	// Center the window
	var x = Math.round((browserW - remoteWidth)  / 2)
	var y = Math.round((browserH - remoteHeight) / 2)
				
	var param = "height=" + remoteHeight + "," +
	            "width="  + remoteWidth  + "," +
				"left="   + x + "," +
				"top="    + y + ",status=yes"
	
	// Open the window
	var newWind = window.open(url, "_blank", param)

	// This workaround is probably not needed, but it
	// won't do any harm and may help in a browser or two
	if (!newWind.opener) newWind.opener = self
}