<%@ taglib uri="/tags/struts-bean" prefix="bean" %>
<%@ taglib uri="/tags/struts-logic" prefix="logic" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>

<div class="header">
<p>
	Status Overview
</p>
<%@ include file="/WEB-INF/tiles/pieces/threadNotice.jsp" %>
</div>
<div class="spacer"></div>

<table style="width:100%" class="status">
	<thead>
		<tr>
			<th>Status</th>
			<th>
				<a href="<html:rewrite page="/Status.page"/>?sortby=description<logic:present name="description">&reverse=true</logic:present>">Task</a>
			</th>
			<th>
				<a href="<html:rewrite page="/Status.page"/>?sortby=result<logic:present name="result">&reverse=true</logic:present>">Result</a>
			</th>
			<th style="width:7em">
				<a href="<html:rewrite page="/Status.page"/>?sortby=started<logic:present name="started">&reverse=true</logic:present>">Time Started</a>
			</th>
			<th style="width:7em">
				<a href="<html:rewrite page="/Status.page"/>?sortby=ended<logic:present name="ended">&reverse=true</logic:present>">Time Finished</a>
			</th>
		</tr>
	</thead>
	<tbody>
		<% int curIdx = 0; %>
		<logic:iterate id="thread" name="threadList" type="live.dto.Thread">
			<% live.dto.Thread th = 
				(live.dto.Thread) pageContext.getAttribute("thread"); 
			   curIdx++;
			%>
			<tr class="<%  
				if(th.getStatus() == live.threads.ThreadedUserAction.CANCELED)
						out.print("canceled");
				else if(th.getStatus() == live.threads.ThreadedUserAction.COMPLETE)
						out.print("complete");
				else if(th.getStatus() == live.threads.ThreadedUserAction.IN_PROGRESS)
						out.print("working");
				else if(th.getStatus() == live.threads.ThreadedUserAction.ERROR)
						out.print("error");
				else if(th.getStatus() == live.threads.ThreadedUserAction.PENDING)
						out.print("pending");
				else if(th.getStatus() == live.threads.ThreadedUserAction.INDETERMINATE)
						out.print("indeterminate");
					
				if(curIdx%2 == 0)
					out.print("Even");
				else
					out.print("Odd");
				%>">
				<td><%  
					if(th.isFinished())
						out.print("Complete");
					else
						out.print("Working");%>
				</td>
				<td>
					<% if(th.isContainer())
					{ %>
						<a href="<html:rewrite page="/Status.page"/>?tid=<bean:write name="thread" property="boxedID"/>">
							<bean:write name="thread" property="description" />
						</a>
					<% } else { %>
						<bean:write name="thread" property="description" />
					<% } %>
				</td>
				<td>
					<bean:write name="thread" property="result"/>
				</td>
				<td>
					<% 
						String date = java.text.DateFormat
							.getTimeInstance(java.text.DateFormat.MEDIUM)
							.format(th.getTimeStarted());
						out.print(date);
					%>
				</td>
				<td>
					<% if(th.getTimeEnded() != null)
					{
						date = java.text.DateFormat
							.getTimeInstance(java.text.DateFormat.MEDIUM)
							.format(th.getTimeEnded());
						out.print(date);
						}
						
					%>
				</td>
			</tr>
		</logic:iterate>
	</tbody>
</table>

<p>(Server time now 
<% 
	String date = java.text.DateFormat
		.getTimeInstance(java.text.DateFormat.MEDIUM)
		.format(new java.util.Date());
	out.print(date);
%>)
