<%@ taglib uri="/tags/struts-logic" prefix="logic" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>

<% 
// I don't know why this is needed, but I'll describe the symptoms of not having
// it. On initial load, everything works correctly no matter if you're creating
// a group or changing members. However, if you are creating a group and you submit
// with an invalid request, when this page is loaded again ${groupName} exists in
// request scope for some reason, but is "". So we just treat this condition the
// same as if ${groupName} wasn't present in the first place. The easiest way to do
// this is to just make it not be present.

if( "".equals(request.getAttribute("groupName")) )
      request.setAttribute("groupName", null);
%>

<html:form action="/Guests/NewGroup.do" method="post">

<logic:notPresent name="groupName">
	<div class="header">
		<p>
			<a href="<html:rewrite page="/Guests/List.page"/>">Guest and Group List</a>   
			New Group
		</p>
		<%@ include file="/WEB-INF/tiles/pieces/threadNotice.jsp" %>
	</div>

	<html:errors/>
	<div class="row" style="width:20em">
		<span class="label required">
			<label for="groupName">Group name:</label>
		</span>
		<span class="field required">
			<html:text property="groupName" styleId="groupName" />
		</span>
	</div>

	<p style="margin-top:0.1em">Select the guests you want to be a member of the new group:</p>
</logic:notPresent>

<logic:present name="groupName">
	<div class="header">
		<p>
			<a href="<html:rewrite page="/Guests/List.page"/>">Guest and Group List</a>   
			Change Members of ${groupName}
		</p>
		<%@ include file="/WEB-INF/tiles/pieces/threadNotice.jsp" %>
	</div>

	<html:errors/>
	<p>Select the guests you want to be a member of ${groupName}:</p>
	<input type="hidden" name="groupName" value="${groupName}"/>
</logic:present>


<% request.setAttribute("multiselect", new Boolean(true));
   request.setAttribute("enterAddresses", new Boolean(false)); %>
<div class="scrollbox" style="margin-top:-0.2em">
	<div class="scrollboxcontents">
		<%@ include file="/WEB-INF/tiles/pieces/guestpick.jsp" %>
	</div>
</div>

<html:submit>Create group</html:submit>
</html:form>