<%@ include file="/WEB-INF/tiles/accept-sniff.jsp" %>
<%@ taglib uri="/tags/struts-bean" prefix="bean" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>
<%@ taglib uri="/tags/struts-logic" prefix="logic" %>

<%
String tableRow;
if(agentIsIE(request)) 
	tableRow = "block";     // works in IE, not Gecko
else
	tableRow = "table-row"; // works in Gecko, not in IE (doesn't know CSS2)
	
%>

<script type="text/javascript">
	function toggleDeleted(vaddr)
	{
		var row = document.getElementById("A" + vaddr)
		var link = (row.getElementsByTagName("a"))[0]
		var newLinkText
		var hiddenField = document.getElementById("diskAddressesToRemove")
		
		if(row.className == "deleted")
		{
			row.className = ""
			newLinkText = document.createTextNode("X")
			var regex = new RegExp(vaddr + "\\|", "g")
			hiddenField.value = hiddenField.value.replace(regex, "");
		}
		else
		{
			row.className = "deleted"
			newLinkText = document.createTextNode("undo")
			hiddenField.value += vaddr + "|"
		}
		
		while ( link.hasChildNodes() )
			link.removeChild ( link.firstChild );
			
		link.appendChild(newLinkText);
	}
	
	var newDiskNo = 0;
	
	function addDiskRow()
	{
		var model = document.getElementById("modelAddRow")
		var newRow = model.cloneNode(true)
		newRow.style.display='<%= tableRow %>'
		newRow.id = 'NEW_' + (++newDiskNo);
		
		var children = newRow.getElementsByTagName("td")
		for(var i=0 ; i<children.length ; ++i)
		{
			var input = children[i].getElementsByTagName("input")[0]
			if(input != null)
				input.name = input.name.replace(/0/, newDiskNo)
		}
		
		var tbody = document.getElementById("newDiskTableBody")
		tbody.appendChild(newRow)
	}
	
	function expandTable()
	{
		document.getElementById('newDiskTable').style.display="table"
		document.getElementById('addDisksExpander').style.display="none"
		document.getElementById('newDisksHeading').style.display="block"
	}
</script>

<div class="header">
<p>
	<a href="<html:rewrite page="/Guests/List.page"/>">Guest and Group List</a>   
	<a href="<html:rewrite page="/Guests/Info.page"/>?guestName=${guestName}">${guestName}</a>   
	Change Minidisks
</p>
<%@ include file="/WEB-INF/tiles/pieces/threadNotice.jsp" %>
</div>
<div class="spacer"></div>

<form action="<html:rewrite page="/Guests/ChMinidisks.do"/>" method="post">

<h2>Existing Disks</h2>
<table class="disks">
	<thead>
		<tr>
			<th>Virtual Address</th>
			<th>Size (MB)</th>
			<th>Access Mode</th>
			<th>Password Protected?</th>
			<th>Delete</th>
		</tr>
	</thead>
	<tbody>
		<logic:iterate id="disk" name="diskList" type="live.dto.MDisk" scope="request">
			<tr id="A<bean:write name="disk" property="virtualAddr"/>">
				<td><bean:write name="disk" property="virtualAddr"/></td>
				<td><bean:write name="disk" property="size"/></td>
				<td><bean:write name="disk" property="mode"/></td>
				<td><!--bean:write name="disk" property="pass"/>--></td>
				<td class="noStrikeout"><a href="" onclick="javascript:toggleDeleted('<bean:write name="disk" property="virtualAddr"/>');return false">X</a></td>
			</tr>
		</logic:iterate> 
	</tbody>
</table>
<input type="hidden" id="diskAddressesToRemove" name="diskAddressesToRemove" />
<input type="hidden" name="guestName" value="${guestName}" />

<% if(!agentIsIE(request))
{%>
<div id="addDisksExpander">
	<img src="<html:rewrite page="/resources/expandDown.jpg"/>" /><a href="#" 
	 onclick="javascript:expandTable();return false">Add Disks</a>
</div>
<%}%>

<h2 <%= agentIsIE(request) ? "" :  "style=\"display:none\"" %> id="newDisksHeading">New Disks</h2>

<table class="disks" id="newDiskTable" <%= agentIsIE(request) ? "" :  "style=\"display:none\"" %>>
	<thead>
		<tr>
			<th>Virtual<br/>Address</th>
			<th class="requiredField">Size (MB)</th>
			<th>Type</th>
			<th>Mode</th>
			<th>Read<br/>Password</th>
			<th>Write<br/>Password</th>
			<th>Multi<br/>Password</th>
		</tr>
	</thead>
	<tbody id="newDiskTableBody">
			<tr id="modelAddRow" <%= agentIsIE(request) ? "style=\"display:none\"" : "" %>>
				<td><input type="text" name="ADDR_0" class="tiny" maxlength="4" /></td>
				<td>
					<input type="text" name="SIZE_0" class="tiny" class="required" />
				</td>
				<td>
					<select name="TYPE_0" class="small" />
						<option value="AUTOG">HDD (minidisk)</option>
						<option value="TDISK">Temporary disk</option>
						<option value="VDISK">RAM disk (VDisk)</option>
					</select>
				</td>
				<td>
					<select name="MODE_0" class="small" />
						<option value="RR">Read only (RR)</option>
						<option value="WR">Write access (WR)</option>
						<option value="MR">Multiple write (MR)</option>
					</select>
				</td>
				<td><input type="text" name="READPW_0" size="8" /></td>
				<td><input type="text" name="WRITEPW_0" size="8" /></td>
				<td><input type="text" name="MULTIPW_0" size="8" /></td>
			</tr>
	</tbody>
	<tfoot>
			<tr>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td style="border:1px solid"><a href="#" onclick="javascript:addDiskRow();return false">Add disk</a></td>
			</tr>
	</tfoot>
</table>

<p><input type="submit"></p>
</form>
