<%@ taglib uri="/tags/struts-bean" prefix="bean" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>
<%@ taglib uri="/tags/struts-logic" prefix="logic" %>

<div class="header">
<p>
	 <a href="<html:rewrite page="/Guests/List.page"/>">Guest and Group List</a>   
	 <a href="<html:rewrite page="/Guests/Info.page"/>?guestName=${guestName}">${guestName}</a>   
	 Change Memory
</p>
<%@ include file="/WEB-INF/tiles/pieces/threadNotice.jsp" %>
</div>
<div class="spacer"></div>

<h1>Change Memory of ${guestName}</h1>

<html:form action="/Guests/ChangeMemory.do" method="post">

	<html:errors/>

	<input type="hidden" name="guestName" value="${guestName}" /> 

	<div class="formlayout" style="width:25em">
		
		<div class="row">
			<span class="column" style="width:10em">
				<span class="required label">
					<label for="defMem">Default memory:</label>
				</span>
				<span class="field">
					<html:select property="defaultMem" styleId="DefMem" 
					             onchange="javascript:memEnable('DefMem')">
						<html:option value="16M">16 MB</html:option>
						<html:option value="32M">32 MB</html:option>
						<html:option value="64M">64 MB</html:option>
						<html:option value="96M">96 MB</html:option>
						<html:option value="128M">128 MB</html:option>
						<html:option value="256M">256 MB</html:option>
						<html:option value="512M">512 MB</html:option>
						<html:option value="1G">1 GB</html:option>
						<html:option value="2G">2 GB</html:option>
						<html:option value="4G">4 GB</html:option>
						<html:option value="custom">(custom)</html:option>
					</html:select>
				</span><br/>
				<span class="field" style="padding-top:0.5em">
					<html:text property="customDefMem" styleId="customDefMem" 
						styleClass="tiny" />
					<html:select property="customDefMemUnits" styleId="customDefMemUnits">
						<html:option value="M">MB</html:option>
						<html:option value="G">GB</html:option>
					</html:select>
				</span>
			</span>
			<span class="column">
				<span class="required label">
					<label for="maxMem">Maximum memory:</label>
				</span>
				<span class="field">
					<html:select property="maximumMem" styleId="MaxMem" 
					             onchange="javascript:memEnable('MaxMem')">
						<html:option value="16M">16 MB</html:option>
						<html:option value="32M">32 MB</html:option>
						<html:option value="64M">64 MB</html:option>
						<html:option value="96M">96 MB</html:option>
						<html:option value="128M">128 MB</html:option>
						<html:option value="256M">256 MB</html:option>
						<html:option value="512M">512 MB</html:option>
						<html:option value="1G">1 GB</html:option>
						<html:option value="2G">2 GB</html:option>
						<html:option value="4G">4 GB</html:option>
						<html:option value="custom">(custom)</html:option>
					</html:select>
				</span><br />
				<span class="field" style="margin-top:0.2em">
					<html:text property="customMaxMem" styleId="customMaxMem" 
					           styleClass="tiny" />
					<html:select property="customMaxMemUnits" styleId="customMaxMemUnits">
						<html:option value="M">MB</html:option>
						<html:option value="G">GB</html:option>
					</html:select>
				</span>
			</span>
		</div>
		
		<div class="row">
			<span class="submit">
				<input type="submit" value="Change Memory" />
			</span>
		</div>
		
</html:form>

<script type="text/javascript">
	function memEnable(basename)
	{
		var theSelect = document.getElementById(basename)
		
		if(theSelect.value == "custom")
		{
			var text = document.getElementById("custom" + basename)
			text.disabled = false
			
			var units = document.getElementById("custom" + basename + "Units")
			units.disabled = false
		}
		else
		{
			var text = document.getElementById("custom" + basename)
			text.disabled = true
			
			var units = document.getElementById("custom" + basename + "Units")
			units.disabled = true
		}
	}
	
	memEnable('DefMem')
	memEnable('MaxMem')
</script>
