<%@ taglib uri="/tags/struts-bean" prefix="bean" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>
<%@ taglib uri="/tags/struts-logic" prefix="logic" %>

<div class="header">
<p>
	<a href="<html:rewrite page="/Guests/List.page"/>">Guest and Group List</a>   
	<a href="<html:rewrite page="/Guests/Info.page"/>?guestName=${guestName}">${guestName}</a>   
	Change Group
</p>
<%@ include file="/WEB-INF/tiles/pieces/threadNotice.jsp" %>
</div>
<div class="spacer"></div>

<html:form action="/Guests/chGuestsGroup.do" method="post" styleId="form">
<html:errors/>

<input type="hidden" name="guestName" value="${guestName}" />
<p>Select the group you want ${guestName} to belong to:</p>
<ul class="clear">
	<logic:iterate id="group" name="groupList">
		<li>
			<html:radio property="groupName" value="${group}" styleId="group_${group}"/>
			<label for="group_${group}">${group}</label>
		</li>
	</logic:iterate>
	<li>
		<html:radio property="groupName" value="<%= live.dto.Group.UNGROUPED_NAME %>" 
			styleId="nogroup" />
		<label for="nogroup"><%= live.dto.Group.UNGROUPED_NAME %></label>
	</li>
	<li style="display:none" id="newGroupElement">
		<html:radio property="groupName" value=":custom:" styleId="newGroup" />
		<input type="text" name="newGroupName" id="newGroupName" />
	</li>
</ul>
<html:submit>Change ${guestName}'s group</html:submit>
</html:form>


<script type="text/javascript">
	var textBox = document.getElementById("newGroupName");
	var newGroupRadio = document.getElementById("newGroup");
	var newGroupElement = document.getElementById("newGroupElement");
	var form = document.getElementById("form");
	
	newGroupElement.style.display = "block";
	
	form.onsubmit = function()
		{
			if(newGroupRadio.checked)
			{
				newGroupRadio.value = textBox.value
			}
		}
	
	textBox.onkeypress = function()
		{
			newGroupRadio.checked = true;
		}
	
	document.onunload = function()
		{
			form.onsubmit = null;
			textbox.onkeypress = null;
			document.onunload = null;
		}
</script>
