<%@ taglib uri="/tags/struts-bean" prefix="bean" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>
<%@ taglib uri="/tags/struts-logic" prefix="logic" %>

<%!
private static final String spacer = "<img src=\"/live/resources/spacer.gif\" /> ";

public static class Mutable_Integer
{
	public int value;
}

public StringBuffer generateHTML(live.threads.Runner runner)
{
	Mutable_Integer i = new Mutable_Integer();
	i.value = 1;
	return generateHTML(runner, 0, i);
}

private StringBuffer generateHTML(live.threads.Runner runner, int depth, Mutable_Integer idx)
{
	StringBuffer sb = new StringBuffer();

	java.util.Collection tasks = (java.util.Collection) runner.rawResult();

	java.util.Iterator iter = tasks.iterator();
	while(iter.hasNext())
	{
		live.threads.ThreadedUserAction task = 
			(live.threads.ThreadedUserAction) iter.next();

		int status = task.getStatus();
		String prefix = "pending";
		if(status == live.threads.ThreadedUserAction.PENDING)
			prefix = "pending";
		else if(status == live.threads.ThreadedUserAction.IN_PROGRESS)
			prefix = "working";
		else if(status == live.threads.ThreadedUserAction.COMPLETE)
			prefix = "complete";
		else if(status == live.threads.ThreadedUserAction.ERROR)
			prefix = "error";
		else if(status == live.threads.ThreadedUserAction.CANCELED)
			prefix = "canceled";
		else if(status == live.threads.ThreadedUserAction.INDETERMINATE)
			prefix = "indeterminate";
			
		String suffix;
		if(idx.value % 2 == 1)
			suffix="Odd";
		else
			suffix="Even";
		
		idx.value++;

		sb.append("<tr class=\"" + prefix + suffix + "\">");		
			sb.append("<td>");
				for(int i=0 ; i<depth ; ++i)
					sb.append(spacer);
				sb.append(task.description());
			sb.append("</td>");
			sb.append("<td>");
				sb.append(task.result());
			sb.append("</td>");
		sb.append("</tr>");
		
		if(task instanceof live.threads.Runner)
		{
			sb.append( generateHTML((live.threads.Runner) task, depth+1, idx) );
		}
		
	}
	
	
	sb.append("</ul></li>");
	return sb;
}
%>
<% live.threads.Runner runner = (live.threads.Runner) request.getAttribute("runner");
%>

<div class="header">
<p>
	<a href="<html:rewrite page="/Status.page"/>">Status Overview</a>   
	Action Status
</p>
<%@ include file="/WEB-INF/tiles/pieces/threadNotice.jsp" %>
</div>
<div class="spacer"></div>

<h1><%= runner.description() %> (<%= runner.result() %>)</h1>

<table class="status"  style="width:85% ; margin-left:5%">
	<thead>
		<tr>
			<th colspan="2" style="text-align:center">Tasks</th>
		</tr>
		<tr>
			<th style="width:55%">Task</th>
			<th>Result</th>
		</tr>
	</thead>
	<tbody>
		<%= generateHTML(runner) %>
	</tbody>
</table>
