<%@ taglib uri="/tags/struts-bean" prefix="bean" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>
<%@ taglib uri="/tags/struts-tiles" prefix="tiles" %>
<%
response.setHeader("Cache-Control","no-store, no-cache, must-revalidate");	//HTTP 1.1
response.setHeader("Pragma","no-cache");		//HTTP 1.0
response.setDateHeader ("Expires", 0);			//prevents caching at the proxy server
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">

<html:html locale="true">
<head>
	<title><tiles:getAsString name="title" /></title>
	<html:base/>
	
	<link rel="stylesheet" href="<html:rewrite page='/resources/global.css'/>" />
	<link rel="stylesheet" href="<html:rewrite page='/resources/styles/status.css'/>" />
	<link rel="stylesheet" href="<html:rewrite page='/resources/styles/forms.css'/>" />
	<link rel="stylesheet" href="<html:rewrite page='/resources/styles/disks.css'/>" />
	<link rel="stylesheet" href="<html:rewrite page='/resources/styles/listStyles.css'/>" />
	<link rel="stylesheet" href="<html:rewrite page='/resources/styles/tabular.css'/>" />
	<link rel="stylesheet" href="<html:rewrite page='/resources/styles/specific.css'/>" />
	
	<script type="text/javascript" src="<html:rewrite page='/resources/global.js'/>"></script>
	<script type="text/javascript" src="<html:rewrite page='/resources/guestListPage.js'/>"></script>
	<script type="text/javascript" src="<html:rewrite page='/resources/guestGroupTree.js'/>"></script>
	
	<tiles:getAsString name="extraHeadInfo" />
</head>

<body>
<div class="banner">
	<span style="padding-right:0.5em ; position:absolute ; right:0px">
		<logic:present name="helpTile">
			<a href="<html:rewrite page="/LoadTile.do"/>?tile=${helpTile}" target="_new" 
			 onclick="javascript:popupRemote('<html:rewrite page="/LoadTile.do"/>?tile=${helpTile}',500,500);return false;"
			 >Help</a> |
		</logic:present>
		
		<a href="<html:rewrite page="/pages/UpdateCache.jsp"/>" target="_new" 
		 onclick="javascript:popupRemote('<html:rewrite page="/pages/UpdateCache.jsp"/>',300,200);return false;"
		 >Update Cache</a> |
		
		<a href="<html:rewrite page="/pages/KillSession.jsp"/>">Logout</a>
	</span>
	<h1 style="display:inline; font-size:250%"><bean:message key="live.name" /></h1>
</div>

<div class="inlineNavigation">
	<ul>
		<li><a href="<html:rewrite page="/Guests/List.page"/>">Guests and Groups</a></li>
		<li><a href="<html:rewrite page="/Networks/List.page"/>">Virtual Networks</a></li>
		<li><a href="<html:rewrite page="/SharedMem/List.page"/>">Shared Memory</a></li>
		<li><a href="<html:rewrite page="/Status.page"/>">Task status</a></li>
	</ul>
</div>

<div class="content">
	<tiles:insert attribute="content"/>
	<div style="float:right">&nbsp;</div>
</div>

</body>
</html:html>
		
