/*
 * testNetworks.java
 * Created on June 18, 2005, 10:52 AM
 */
package live.test.zvmtasks;

import junit.framework.*;
import java.util.ListIterator;
import java.util.LinkedList;
import java.util.Iterator;

import live.zvmtasks.ZVMTasks;
import live.zvmtasks.ZVMTasksException;
import live.dto.Network;

/* Assumptions being made:
 *
 * - Username, password, ip, and port are fixed.
 * - LIVET000 exists
 *
 */

public class testNetworks extends TestCase    
{
    ZVMTasks tasks;

    protected void setUp()
    {
	tasks = new ZVMTasks("9.60.9.216", 44444, "VSMSTEVE", "SS4VSM");
    }

    protected void tearDown()
    {
	/* Need not do anything here :) */
    }

    public static void main(String args[])
    {
	junit.textui.TestRunner.run(suite());
    }

    public static Test suite()
    {
	return new TestSuite(testNetworks.class);
    }
/*
    public void testNetCreateQueryDelLAN()
	throws ZVMTasksException
    {
	//Ensure the test lan does not exist.
	try
	{
	    tasks.guestLANDeleteDisconnect("LIVELAN",  "OPERATOR", "767");
	} catch(ZVMTasksException e) { }
	
	tasks.guestLANCreateConnect("LIVELAN",  "OPERATOR", "767");
	
	tasks.guestLANDeleteDisconnect("LIVELAN",  "OPERATOR", "767");
    }
    */
       public void testNetCreateQueryDelVSwitch()
	throws ZVMTasksException, Exception
    {
	//Ensure the test vswitch does not exist.
	try
	{
	    tasks.virtualSwitchDetatch("VSWITCHE",  "LIVET000");
	    tasks.virtualSwitchDelete("VSWITCHE");
	} catch(ZVMTasksException e) { }
	
	LinkedList memberNames = new LinkedList();
	memberNames.add("LIVET000");
	String addr = tasks.getCommonAddress(memberNames);	
	tasks.virtualSwitchCreateConnect("VSWITCHE",  "LIVET000", addr, "","");
	
	tasks.virtualSwitchDetatch("VSWITCHE",  "LIVET000");
	tasks.virtualSwitchDelete("VSWITCHE");
    }
    public void testGetNetworkMembers()
	throws ZVMTasksException, Exception
    {
	//Ensure the test vswitch does not exist.
	try
	{
	    tasks.virtualSwitchDetatch("VSWITCHE2",  "LIVET000");
	    tasks.virtualSwitchDelete("VSWITCHE2");
	} catch(ZVMTasksException e) { }
	
	String addr = tasks.findNICaddress("LIVET000");
	tasks.virtualSwitchCreateConnect("VSWITCH2",  "LIVET000", addr, "","");
	Network curnet = tasks.getNetworkMembers("VSWITCH2");
	Iterator iter2 = curnet.getMembers().iterator();
	boolean found_Operator = false;
		    
	while(iter2.hasNext())
	{
	    String element = (String) iter2.next();
	    if(element.equals("LIVET000"))
	    found_Operator = true;
	}
				
	assertTrue(found_Operator);
	assertEquals(curnet.getMembers().size(), 1);
	tasks.virtualSwitchDetatch("VSWITCH2",  "LIVET000");
	tasks.virtualSwitchDelete("VSWITCH2");
    }
    public void testGetNetworkMembersbad()
	throws ZVMTasksException, Exception
    {
	//Ensure the test vswitch does not exist.
	try
	{
	    tasks.virtualSwitchDetatch("VSWITCHE3",  "LIVET000");
	    tasks.virtualSwitchDelete("VSWITCHE3");
	} catch(ZVMTasksException e) { }
	try
	{
	    Network curnet = tasks.getNetworkMembers("VSWITCHE3");
	}
	catch (ZVMTasksException e)
	{
	    return;
	}
	fail("Should not have found VSWITCHE");
	
    }
 
    public void testGetAllNetworkNames()
	throws ZVMTasksException, Exception
     {
	try
	{
	    tasks.virtualSwitchDetatch("TSWIT6",  "LIVET000");
	    tasks.virtualSwitchDelete("TSWIT6");
	} catch(ZVMTasksException e) { }
	try 
	{
	    tasks.virtualSwitchCreate("TSWIT6", "portpw", "1e1f"); 
	    LinkedList memberNames = new LinkedList();
	    memberNames.add("LIVET000");
	    String addr = tasks.getCommonAddress(memberNames);
	    tasks.virtualSwitchCreateConnect("TSWIT6", "LIVET000", addr, "", "");
	    
	    LinkedList lists = tasks.getAllNetworkNames();
			
	    Iterator iter = lists.iterator();
	    while(iter.hasNext())
	    {
		
		Network n = (Network) iter.next();
		if(n.getNetworkName().equals("TSWIT6"))
		{
		    Iterator iter2 = n.getMembers().iterator();
		    boolean found_LIVET = false;
		    
		    while(iter2.hasNext())
		    {
			String element = (String) iter2.next();
			if(element.equals("LIVET000"))
			found_LIVET = true;
		    }
		    tasks.virtualSwitchDetatch("TSWIT6", "LIVET000");
		    tasks.virtualSwitchDelete("TSWIT6");
		    assertTrue(found_LIVET);
		    //assertEquals(3, n.getMembers().size());

		    return;
	    	}
	   }
	   
	   fail("TSWIT6 was not found as a network!!!");
	}
		catch(ZVMTasksException e) 
		{
			throw new ZVMTasksException(e.getMessage());
		}
	
    }
    public void testQueryAllNetworks()
	throws ZVMTasksException
    {
	try
	{
	    tasks.virtualSwitchDetatch("LIEFERIK",  "LIVET000");
	    tasks.virtualSwitchDelete("LIEFERIK");
	} catch(ZVMTasksException e) { }
	

	LinkedList memberNames = new LinkedList();
	memberNames.add("LIVET000");
	String addr = tasks.getCommonAddress(memberNames);
	tasks.virtualSwitchCreate("LIEFERIK", "portpw", "1E1E");
	tasks.virtualSwitchCreateConnect("LIEFERIK", "LIVET000", addr, "", "");
	LinkedList networks = tasks.getAllNetworkNames();
	Iterator iter2 = networks.iterator();
	boolean found_lieferik = false;
	boolean found_LIVET000 = false;
		   
	while(iter2.hasNext() && found_lieferik == false)
	{
	    Network element = (Network) iter2.next();
	    if(element.getNetworkName().equals("LIEFERIK"))
	    found_lieferik = true;
	    Iterator itermem = element.members.iterator();
	    while (itermem.hasNext())
	    {
		String memname = (String)itermem.next();
		if(memname.equals("LIVET000")) found_LIVET000 = true;
	    }
	}
	assertTrue(found_LIVET000);
	assertTrue(found_lieferik);
	tasks.virtualSwitchDetatch("LIEFERIK", "LIVET000");
	tasks.virtualSwitchDelete("LIEFERIK");
    }
  
}