/*
 * testMisc.java
 *
 * Created on July 8, 2005, 1:39 PM
 */
package live.test.zvmtasks;

import junit.framework.*;
import java.util.ListIterator;
import java.util.LinkedList;
import java.util.Iterator;

import live.zvmtasks.ZVMTasks;
import live.dto.Interval;
import live.zvmtasks.ZVMTasksException;
import live.smapi.exceptions.*;
import live.smapi.SMAPI_Interface;


/* Assumptions being made:
 *
 * - Username, password, ip, and port are fixed.
 * - LIVET000 exists
 *
 */
public class testMisc extends TestCase
{
    ZVMTasks tasks;
    ZVMTasks badtasks;
    SMAPI_Interface smapi;

     protected void setUp()
    {
	tasks = new ZVMTasks("9.60.9.216", 44444, "VSMSTEVE", "SS4VSM");
	badtasks = new ZVMTasks("9.60.9.216", 44444, "BADUSER", "BADPASSWORD");
	smapi = new SMAPI_Interface("9.60.9.216", 44444, "VSMSTEVE", "SS4VSM");
    }

    protected void tearDown()
    {
	/* Need not do anything here :) */
    }

    public static void main(String args[])
    {
	junit.textui.TestRunner.run(suite());
    }

    public static Test suite()
    {
	return new TestSuite(testMisc.class);
    }
    public void testAuthenticate()
	throws ZVMTasksException
    {
	boolean i =tasks.authenticate();
	assertTrue(i);
    }
    
    public void testAuthenticateFail()
	throws ZVMTasksException
    {
	boolean i = badtasks.authenticate();
	assertFalse(i);
    }
    public void testgetStorageGaps()
	throws ZVMTasksException
    {
	LinkedList a = tasks.getStorageGaps("STEVE2");
	ListIterator iter = a.listIterator();
	while (iter.hasNext())
	{
	   Interval thisint = (Interval)iter.next();
	}
    }
    public void testgetLowestCommonAddress()
	throws ZVMTasksException
    {
	LinkedList members = new LinkedList();
	members.add("STEVE2");
	members.add("LIVET000");
	members.add("RSCS");
	String a = tasks.getCommonAddress(members);
    }
}
