package live.test.zvmtasks;

import junit.framework.*;
import java.util.ListIterator;
import java.util.LinkedList;
import java.util.Iterator;
	
import live.smapi.SMAPI_Interface;
import live.smapi.exceptions.*;
import live.zvmtasks.ZVMTasks;
import live.zvmtasks.ZVMTasksException;
import live.dto.Guest;
import live.dto.Group;
import live.dto.MDisk;


/* Assumptions being made:
 *
 * - Username, password, ip, and port are fixed.
 * - OPERATOR exists,
 *
 */

public class testGuests extends TestCase    
{
    ZVMTasks tasks;
    SMAPI_Interface smapi;
    protected void setUp()
    {
	tasks = new ZVMTasks("9.60.9.216", 44444, "VSMSTEVE", "SS4VSM");
	smapi = new SMAPI_Interface("9.60.9.216", 44444, "VSMSTEVE", "SS4VSM");
    }

    protected void tearDown()
    {
	/* Need not do anything here :) */
    }

    public static void main(String args[])
    {
	junit.textui.TestRunner.run(suite());
    }

    public static Test suite()
    {
	return new TestSuite(testGuests.class);
    }

    public void testGuestNamesQuery()
	throws ZVMTasksException
    {
	LinkedList guests = tasks.queryAllGuestNames();
	
	ListIterator itr = guests.listIterator();
	while(itr.hasNext())
	{
	    if( ((String)itr.next()).equals("OPERATOR") ) return;
	}
	
	fail("Should have found OPERATOR!");
    }
    
    public void testGuestQuery()
	throws ZVMTasksException
    {
	
	Guest g = tasks.queryGuest("OPERATOR");
	
	assertTrue(g.getGuestName().equals("OPERATOR"));
    }
    public void testchangeGuestsGroup()
	throws ZVMTasksException
    {
	tasks.setGuestsGroup("LIVET000", null, "OUP");
	LinkedList groups = tasks.getGroups();
	Iterator itr = groups.iterator();
	boolean found_livet000 = false;
	while(itr.hasNext())
	{
	    Group groupa = (Group)itr.next();
	    if (groupa.getGroupName().equals("OUP"))
	    {
		Iterator itr2 = groupa.getMembers();
		while(itr2.hasNext())
		{
		    String element = (String) itr2.next();
		    if (element.equals("LIVET000")) found_livet000=true;
		}
	    }
	}
	assertTrue(found_livet000);
    }
    public void testGuestCreateQueryDelete()
	throws Exception
    {
	//Ensure test guest does not already exist.
	try { tasks.deleteImage("LIVET010"); }
	catch(ZVMTasksException e) { }
	
	tasks.createGuest("LIVET010", "PASS", "64M", "256M", ZVMTasks.PROFILE_SUPER);
	
	tasks.queryGuest("LIVET010");
	
	//tasks.deleteImage("LIVET010");
    }
    public void testSetGuestsPassword()
	throws Exception
    {
	tasks.setGuestPassword("LIVET000", "newtest");
	tasks.setGuestPassword("LIVET000", "test");
    }

    public void testCloneGuest()
	throws ZVMTasksException, SMAPIException
    {
	try {tasks.deleteImage("CLOP2");}
	catch(ZVMTasksException e) { }
	
	//tasks.queryGuest("QWTRTY");
	LinkedList stuff = tasks.cloneGuest("OP1", "CLOP2", "test", false, true);
	System.out.println(stuff);
    }
    public void testCreateQueryDeletemDisks()
	throws ZVMTasksException
    {
	try{tasks.deleteMDisk("CLop1", "3484");}
	catch(ZVMTasksException e) { }
	tasks.createMDisk("CLop1", "3484", "AUTOG", "4", "WR", " ", " ", " ");
	LinkedList mdisks = tasks.queryMDisks("CLOP1");
	ListIterator iter = mdisks.listIterator();
	boolean found_disk = false;
	while (iter.hasNext())
	{
	    MDisk thisDisk = (MDisk)iter.next();
	    if (thisDisk.getVirtualAddr().equals("3484"))
		found_disk = true;
	}
	assertTrue(found_disk);
	//tasks.deleteMDisk("QWORTY", "3464");
    }
   
}