/*
 * testCache.java
 * Created on June 13, 2005, 3:18 PM
 */

package live.test.threads;

import junit.framework.*;
import live.threads.ActiveThreadsInfo;
import live.threads.WaitAction;
import live.threads.ThreadInitInfo;
import java.util.LinkedList;
import java.util.Iterator;

public class test_multithreadedness extends TestCase
{
    private WaitAction[] threads;
	private final int numthreads = 10;
	
	private ActiveThreadsInfo lists;
		
    protected void setUp()
    {
		lists = new ActiveThreadsInfo();
		lists.setTimeThreshold(0);
		
		threads = new WaitAction[numthreads];
		for(int i=0 ; i<numthreads ; ++i)
		{
			threads[i] = new WaitAction(new ThreadInitInfo(null, lists, null), (double)i/10);
		}
    }

    public static void main(String args[])
    {
		junit.textui.TestRunner.run(suite());
    }

    public static Test suite()
    {
		return new TestSuite(testActiveThreadsInfo.class);
    }
	
	public void testMarkInProgress()
	{
		for(int i=0 ; i<numthreads ; ++i)
		{
			threads[i].start();
		}
		
		try  { Thread.sleep(50); }
		catch(InterruptedException e) { /* Smile, Mr. Compiler */ }
		
		for(int i=numthreads-1 ; i>=0 ; --i)
		{
			LinkedList ip = lists.getInProgress();
			synchronized(ip)
			{
				assertEquals(ip.size(), i);
			}
			
			LinkedList done = lists.getRecentlyComplete();
			assertEquals(done.size(), 1);

			try  { Thread.sleep(100); }
			catch(InterruptedException e) { /* Smile, Mr. Compiler */ }
		}
	}
}
