/*
 * testCache.java Created on June 13, 2005, 3:18 PM
 */

package live.test.threads;

import junit.framework.*;
import live.threads.ActiveThreadsInfo;
import live.threads.WaitAction;
import live.threads.ThreadInitInfo;
import java.util.LinkedList;
import java.util.Iterator;
import live.threads.ThreadedUserAction;

public class testActiveThreadsInfo extends TestCase
{
	private WaitAction[] threads;

	private final int numthreads = 5;

	private ActiveThreadsInfo lists;

	private ActiveThreadsInfo lists2;

	protected void setUp()
	{
		lists = new ActiveThreadsInfo();
		lists2 = new ActiveThreadsInfo();
		ThreadInitInfo threads2 = new ThreadInitInfo(null, lists2, null);

		threads = new WaitAction[numthreads];
		for(int i = 0 ; i < numthreads ; ++i)
		{
			threads[i] = new WaitAction(new ThreadInitInfo(null, lists, null), i);
		}
	}

	public static void main(String args[])
	{
		junit.textui.TestRunner.run(suite());
	}

	public static Test suite()
	{
		return new TestSuite(testActiveThreadsInfo.class);
	}

	public void testMarkInProgress()
	{
		for(int i = 0 ; i < numthreads ; ++i)
		{
			lists.markInProgress(threads[i]);
		}

		Iterator iter = lists.getInProgress().iterator();

		for(int i = 0 ; i < numthreads ; ++i)
		{
			assertTrue(iter.hasNext());
			Thread t = (Thread)iter.next();

			assertEquals(t.toString(), "ThreadedUserAction: Waiting "
					+ (i * 1000));
		}
	}

	public void testMarkComplete()
	{
		/*System.out.println(numthreads);
		for(int i = 0 ; i < numthreads ; ++i)
		{
			System.out.println(threads[i].toString());
			lists2.markComplete(threads[i]);
		}
		Iterator iter = lists.getCompletedJobs().iterator();

		for(int i = 0 ; i < numthreads ; ++i)
		{
			//assertTrue(iter.hasNext());
			Thread t = (Thread)iter.next();

			System.out.println(t.toString());
		}*/
		
		// This test is commented out because it breaks.
		//
		// But, it doesn't break because what it's testing
		// is broken, it breaks because it breaks the contract
		// of how the ThreadedUserAction is supposed to be used.
		// getTimeStarted() returns null if it hasn't started yet
		// (only reasonable) so you can't use it to, say, call
		// getTime(). Yet that's exactly what markComplete does.
		// The starting time isn't ever set because this never calls
		// run().
	}
}
