package live.test.smapi;

import junit.framework.*;
import java.util.ListIterator;
import java.util.LinkedList;
import java.util.Iterator;

import live.smapi.SMAPI_Interface;
import live.smapi.exceptions.*;
import live.dto.Network;
import live.dto.NameList;

/* Assumptions being made:
 *
 * - Username, password, ip, and port are fixed.
 * - LIVET000 guest exists.
 * - OPERATOR is logged on.
 * - VSwitch LVS00 - LVS10 do not exist.
 * - OPERATOR vdev 760-763 are not used.
 * - MAINT guest exists
 * - MAINT vdev 760-763 are not used.
 */

public class testVSwitches extends TestCase
{
    SMAPI_Interface smapi;
    
    protected void setUp()
    {
	smapi = new SMAPI_Interface("9.60.9.216", 44444, "VSMSTEVE", "SS4VSM");
    }

    protected void tearDown()
    {
	/* Need not do anything here :) */
    }

    public static void main(String args[])
    {
	junit.textui.TestRunner.run(suite());
    }
    
    public static Test suite()
    {
	return new TestSuite(testVSwitches.class);
    }
    
    public void testCreateQueryDeleteVSwitch()
	throws Exception
    {
	try
	{
	    String addr = smapi.getNICaddress("LVS00", "LIVET000");
	    int i = smapi.virtualSwitchDisconnectAndDelete("LIVET000", "LVS00", addr);
	}
	catch (SMAPIException e)
	{
	}
	String addr = smapi.getLowestFreeAddress("LIVET000", "3");
	Network curNet;
	boolean foundVSWITCHE = false;
	int i = smapi.virtualSwitchCreateAndConnect("LVS00", "LIVET000", addr, "", "");
	assertTrue(i==0 || i==1 || i==2);
	
	smapi.virtualSwitchSet("LVS00", "", "LIVET000");
	
	LinkedList networks = smapi.virtualLanQuery();

	
	ListIterator itr = networks.listIterator();
	while(itr.hasNext() && foundVSWITCHE == false)
	{
	    curNet = (Network)itr.next();
		    
	    if(curNet.getNetworkName().equals("LVS00") && curNet.getNetworkType() == Network.NETWORK_VSWITCH)
		foundVSWITCHE = true;
	}
	if (!foundVSWITCHE) fail("Should have found VSWITCHE!");
	
	i = smapi.virtualSwitchDisconnectAndDelete("LIVET000", "LVS00", addr);
	assertTrue(i==0 || i==1 || i==2);

     }
/*    
    public void testCreateNewCreate()
	throws Exception
    {
	smapi.virtualSwitchCreate("LVS01", "", "");
	int i;
	String addr = smapi.getLowestFreeAddress("STEVE2", "3");
	String addr2 = smapi.getLowestFreeAddress("LIVET001", "3");
	try
	{
	    i = smapi.virtualSwitchCreateAndConnect("LVS01", "STEVE2", addr, "", "");
	    assertTrue(i==0 || i==1 || i==2);	    
	}
	catch(ImageNotActiveException e)
	{
	    //Is ok if guest is not logged on.
	}
	
	try
	{
	    i = smapi.virtualSwitchCreateAndConnect("LVS01", "LIVET001", addr2, "", "");
	    assertTrue(i==0 || i==1 || i==2);
	}
	catch(ImageNotActiveException e)
	{
	    //Is ok if guest is not logged on.
	}
	
	LinkedList networks = smapi.virtualLanQuery();
	Network curNet;
	boolean foundNet = false;
	
	ListIterator itr = networks.listIterator();
	while(itr.hasNext() && foundNet == false)
	{
	    curNet = (Network)itr.next();
		    
	    if(curNet.getNetworkName().equals("LVS01") && curNet.getNetworkType() == Network.NETWORK_VSWITCH)
		foundNet = true;
	}
	if (!foundNet) fail("Should have found LVS01!");
	
	// test switch already exist case
	boolean ex = false;
	try
	{
	    smapi.virtualSwitchCreate("LVS01", "", "");
	}
	catch(VSwitchAlreadyExistsException e)
	{
	    ex = true;
	}
	if(!ex) fail("Should have thrown a vswitch already exists exception!");
	
	
	try
	{
	    i = smapi.virtualSwitchDisconnectAndDelete("STEVE2", "LVS01", addr);
	    assertTrue(i==0 || i==1 || i==2);
	}
	catch(ImageNotActiveException e)
	{
	    //Is ok if guest is not logged on.
	}
	
	try
	{
	    i = smapi.virtualSwitchDisconnectAndDelete("LIVET001", "LVS01", addr2);
	    assertTrue(i==0 || i==1 || i==2);
	}
	catch(ImageNotActiveException e)
	{
	    //Is ok if guest is not logged on.
	}
    }
    */
    public void testCreateNewCreateWithRdev()
	throws Exception
    {
	try
	{
	    String addr = smapi.getNICaddress("LVS02", "LIVET000");
	    int i = smapi.virtualSwitchDisconnectAndDelete("LIVET000", "LVS02", addr);
	}
	catch (SMAPIException e)
	{
	}
	smapi.virtualSwitchCreate("LVS02", "portpw", "1e1e");
	String addr = smapi.getLowestFreeAddress("LIVET000", "3");
	int i;
	try
	{
	    i = smapi.virtualSwitchCreateAndConnect("LVS02", "LIVET000", addr, "", "");
	    assertTrue(i==0 || i==1 || i==2);
	    
	}
	catch(ImageNotActiveException e)
	{
	    //Is ok if guest is not logged on.
	}

	LinkedList networks = smapi.virtualLanQuery();
	Network curNet;
	boolean foundNet = false;
	
	ListIterator itr = networks.listIterator();
	while(itr.hasNext() && foundNet == false)
	{
	    curNet = (Network)itr.next();
		    
	    if(curNet.getNetworkName().equals("LVS02") && curNet.getNetworkType() == Network.NETWORK_VSWITCH)
		foundNet = true;
	}
	if (!foundNet) fail("Should have found LVS02!");
	
	/* test switch already exist case*/
	boolean ex = false;
	try
	{
	    smapi.virtualSwitchCreate("LVS02", "", "");
	}
	catch(VSwitchAlreadyExistsException e)
	{
	    ex = true;
	}
	if(!ex) fail("Should have thrown a vswitch already exists exception!");
	
	
	try
	{
	    i = smapi.virtualSwitchDisconnectAndDelete("LIVET000", "LVS02", addr);
	    assertTrue(i==0 || i==1 || i==2);
	}
	catch(ImageNotActiveException e)
	{
	    //Is ok if guest is not logged on.
	}
    }
  
    public void testQueryNetworks()
	throws Exception
    {
	//Make sure TSWIT does not exist
	try
	{
	    String addr = smapi.getNICaddress("TSWIT", "LIVET000");
	    int i = smapi.virtualSwitchDisconnectAndDelete("LIVET000", "TSWIT", addr);
	}
	catch (SMAPIException e) {}
	
	try 
	{
	    //Add LIVET000 to TSWIT 
	    smapi.virtualSwitchCreate("TSWIT", "portpw", "1e1f"); 
	    String addr = smapi.getLowestFreeAddress("LIVET000", "3");
	    int i = smapi.virtualSwitchCreateAndConnect("TSWIT", "LIVET000", addr, "", "");
	    
	    //Query all networks
	    boolean found_LIVET = false;
	    LinkedList lists = smapi.queryNetworkMembers("");
			
	    //Iterate through lists until we find TSWIT
	    Iterator iter = lists.iterator();
	    while(iter.hasNext())
	    {
		Network n = (Network) iter.next();
		
		if(n.getNetworkName().equals("TSWIT"))
		{
		    Iterator iter2 = n.getMembers().iterator();
		    
		    //Find LIVET000 in TSWIT
		    while(iter2.hasNext())
		    {
			String element = (String) iter2.next();
			if(element.equals("LIVET000"))
			found_LIVET = true;
		    }
	    	
		}

	    }
	    addr=smapi.getNICaddress("TSWIT", "LIVET000");
	    i=smapi.virtualSwitchDisconnectAndDelete("LIVET000", "TSWIT", addr);
	    assertTrue(found_LIVET);
	    return;
	}
	
	catch(SMAPIException e) 
	{
	    fail("Exception thrown: " + e.toString());
	}
	
    }
    
    
    public void testQueryNetworks2()
	throws Exception
    {
	//Make sure network does not exist
	try
	{
	    String addr = smapi.getNICaddress("TSWIT2", "LIVET000");
	    int i = smapi.virtualSwitchDisconnectAndDelete("LIVET000", "TSWIT2", addr);
	}
	catch (SMAPIException e) {}
	
	
	try 
	{
	    //Add LIVET000 to TSWIT2
	    smapi.virtualSwitchCreate("TSWIT2", "portpw", "1e1f"); 
	    String addr = smapi.getLowestFreeAddress("LIVET000", "3");
	    int i = smapi.virtualSwitchCreateAndConnect("TSWIT2", "LIVET000", addr, "", "");
	    
	    //Query TSWIT2
	    boolean found_LIVET = false;
	    LinkedList lists = smapi.queryNetworkMembers("TSWIT2");
			
	    //Make sure we got the right network
	    assertEquals(lists.size(),1);
	    Network n = (Network) lists.removeFirst();
	    assertEquals(n.getNetworkName(), "TSWIT2");
	    
		    
	    //Iterate through and find LIVET000
	    Iterator iter2 = n.getMembers().iterator(); 
	    while(iter2.hasNext())
	    {
		String element = (String) iter2.next();
		if(element.equals("LIVET000"))  found_LIVET = true;
	    }
	    
	    //Check to make sure we found LIVET000 and disconnect him
	    assertEquals(n.getMembers().size(), 1);
	    assertTrue(found_LIVET);
	    addr=smapi.getNICaddress("TSWIT2", "LIVET000");
	    i=smapi.virtualSwitchDisconnectAndDelete("LIVET000", "TSWIT2", addr);
	    return;
	}
	
	catch(Throwable e) 
	{
	    fail("Exception thrown: " + e.toString());
	}
	
    }
    
    
    public void testQueryNetworksBad()
	throws Exception
    {
	try 
	{	    
	    LinkedList lists = smapi.queryNetworkMembers("TSWIT3");
	    Iterator iter = lists.iterator();

	}
	catch(VSwitchDoesNotExistException e) 
	{
	    return;
	}
	fail("Should not have found TSWIT3");
    }
    
    
   public void testGetNICAddress()
	throws Exception
   {
       //Make sure network does not exist
       try
       {
	   String addr = smapi.getNICaddress("TSWIT4", "LIVET000");
	   int i = smapi.virtualSwitchDisconnectAndDelete("LIVET000", "TSWIT4", addr);
       }
       catch (SMAPIException e) {}
       
       //Connect LIVET000 to TSWIT4
       smapi.virtualSwitchCreate("TSWIT4", "portpw", "1e1f"); 
       String addr = smapi.getLowestFreeAddress("LIVET000", "3");
       int i = smapi.virtualSwitchCreateAndConnect("TSWIT4", "LIVET000", addr, "", "");

       //Find LIVET000 on TSWIT4, disconnect
       String newaddr = smapi.getNICaddress("TSWIT4", "LIVET000");
       smapi.virtualSwitchDisconnectAndDelete("LIVET000", "TSWIT4", newaddr);
       
       //Ensure that the connect/disconnect addresses were the same
       assertEquals(addr, newaddr);
	
   }
   
   
   public void testGetNICAddressBad()
	throws Exception
   {
       //Make sure network does not exist
       try
       {
	   String addr = smapi.getNICaddress("TSWIT5", "LIVET000");
	   int i = smapi.virtualSwitchDisconnectAndDelete("LIVET000", "TSWIT5", addr);
       }
       catch (SMAPIException e)
       {}
       
       try
       {
	   smapi.imageActivate("op1");
	   String conaddr = smapi.getLowestFreeAddress("op1", "3");
	   smapi.virtualSwitchCreateAndConnect("TSWIT5", "op1", conaddr, "", "");
	   String addr = smapi.getNICaddress("TSWIT5", "LIVET000");
       }
       
       catch (ImageDeviceNotConnectedException e)
       {
	   int i=smapi.virtualSwitchDisconnectAndDelete("op1", "TSWIT5", "000F");
	   return;
       }
       
       fail("Should not have found LIVET000 on switch");
   }
   
   
   public void testGetNICAddressBad2()
	throws Exception
   {
   
       try
       {
	   String addr = smapi.getNICaddress("TSWIT6", "LIVET000");
       }
       
       catch (VSwitchDoesNotExistException e)
       {
	   return;
       }
       
       fail("Should not have found switch TSWIT6");
   }
   
    public void testVSwitchSeparateDetatchDelete()
	throws Exception
    {
	//ensure our switch does not exist before starting test 
       try
       {
	   String addr = smapi.getNICaddress("LVS00", "LIVET000");
	   int i = smapi.virtualSwitchDisconnectAndDelete("LIVET000", "LVS00", addr);
       }
       catch (SMAPIException e) {}

	//Create a vsw and attach a guest to it
	smapi.virtualSwitchCreate("LSV00", "", "");
        smapi.virtualSwitchCreateAndConnect("LSV00", "LIVET000", "1e2a", "", "");
	
	//Ensure switch (exists
	LinkedList lanNames = smapi.virtualLanQuery();
	ListIterator itr = lanNames.listIterator();
	boolean found = false;
	while(itr.hasNext())
	{
	    //System.out.println((String)itr.next());
	    if (((Network)itr.next()).getNetworkName().equals("LSV00")) found = true;
	}
	assertTrue(found);
	
	//det guest's NIC
	smapi.virtualSwitchDetatch("LIVET000", "1e2a");
	
	//ensure sw still exists
	lanNames = smapi.virtualLanQuery();
	itr = lanNames.listIterator();
	found = false;
	while(itr.hasNext())
	{
	    //System.out.println((String)itr.next());
	    if (((Network)itr.next()).getNetworkName().equals("LSV00")) found = true;
	}
	assertTrue(found);
	
	//del sw
	smapi.virtualSwitchDelete("LSV00");
	
	//ensure switch does not exist

	LinkedList laNames = new LinkedList();
	try
	{
	    laNames = smapi.virtualLanQuery();
	}
	catch (SMAPIException e) {}
	itr = laNames.listIterator();
	found = false;
	while(itr.hasNext())
	{
	    //System.out.println((String)itr.next());
	    if (((Network)itr.next()).getNetworkName().equals("LSV00")) found = true;
	}
	assertTrue(!found);
   }
}

