/*
 * testPrototypes.java
 * Created on July 11, 2005, 8:09 AM
 */
package live.test.smapi;

import junit.framework.*;
import java.util.ListIterator;
import java.util.LinkedList;

import live.smapi.SMAPI_Interface;
import live.smapi.exceptions.*;

/* Assumptions being made:
 *
 * - Username, password, ip, and port are fixed.
 * - No user named NONAME
 *
 */

public class testPrototypes extends TestCase
{

    SMAPI_Interface smapi;
    LinkedList lines;
    
    protected void setUp()
    {
	smapi = new SMAPI_Interface("9.60.9.216", 44444, "VSMSTEVE", "SS4VSM");
	
	lines = new LinkedList();
	lines.add("USER TESTP XXXXXXXX 128M 128M ABCDEFGHIJKLMNOPQRSTUVWXYZ"); /* 56 */
	lines.add("INCLUDE CMSDFLT");
    }

    protected void tearDown()
    {
	/* Need not do anything here :) */
    }

    public static void main(String args[])
    {
	junit.textui.TestRunner.run(suite());
    }
    
    public static Test suite()
    {
	return new TestSuite(testPrototypes.class);
    }
    
    public void testPrototypeCreateQueryDelete()
	throws Exception
    {
	//Ensure our test prototype does not exist before starting.
	try { smapi.prototypeQuery("PLIVET"); }
	catch (PrototypeNotFoundException e) { }
	
	smapi.prototypeCreate("PLIVET", lines);
	
	boolean found = false;
	ListIterator itr = smapi.prototypeNameQuery().listIterator();
	while(itr.hasNext() && !found)
	{
	    found = ((String)itr.next()).equals("PLIVET");
	}
	if(!found) fail("Should have found prototype PLIVET!");
	
	smapi.prototypeDelete("PLIVET");
	
	try { smapi.prototypeQuery("PLIVET"); }
	catch (PrototypeNotFoundException e) { return; }
	
	fail("Should NOT have found prototype PLIVET!");
    }
    
}