package live.test.smapi;

import junit.framework.*;
import java.util.ListIterator;
import java.util.Iterator;
import java.util.LinkedList;

import live.smapi.SMAPI_Interface;
import live.smapi.exceptions.*;

import live.dto.NameList;

/* Assumptions being made:
 *
 * - Username, password, ip, and port are fixed.
 * - No namelist named "NOLISTNAME"
 *
 */

public class testNamelists extends TestCase
{
    SMAPI_Interface smapi;
    
    protected void setUp()
    {
	smapi = new SMAPI_Interface("9.60.9.216", 44444, "VSMSTEVE", "SS4VSM");
    }

    protected void tearDown()
    {
	/* Need not do anything here :) */
    }

    public static void main(String args[])
    {
	junit.textui.TestRunner.run(suite());
    }
    
    public static Test suite()
    {
	return new TestSuite(testNamelists.class);
    }
    
    public void testQueryNoList()
	throws Exception
    {
	try
	{
	LinkedList lst = smapi.nameListQuery("NOLISTNAME");
	}
	catch(ListNotFoundException e)
	{
	    return;
	}
	
	fail("Should not have found a namelist!");
    }
    public void testDestroyNoList()
	throws Exception
    {
	try
	{
	smapi.nameListDestroy("NOLISTNAME");
	}
	catch(ListNotFoundException e)
	{
	    return;
	}
	
	fail("Should not have found a namelist!");
    }
    public void testRemoveNoList()
	throws Exception
    {
	try
	{
	smapi.nameListRemove("NOLISTNAME", "NOUSERNAM");
	}
	catch(ListNotFoundException e)
	{
	    return;
	}
	
	fail("Should not have found a namelist!");
    }
    public void testQueryBadparam()
	throws Exception
    {
	try
	{
	    LinkedList lst = smapi.nameListQuery("bad~name~list~name");
	}
	catch(ParmSyntaxErrException e)
	{
	    return;
	}
	
	fail("Should not have found a namelist!");
    }
    
    public void testAddBadparam()
	throws Exception
    {
	try
	{
	    int i = smapi.nameListAdd("bad~name~list~name", "bad~user~name~thingy");
	}
	catch(ParmSyntaxErrException e)
	{
	    return;
	}
	
	fail("Should not have been able to add guest!");
    }
    
    public void testDestroyBadparam()
	throws Exception
    {
	try
	{
	    smapi.nameListDestroy("bad~name~list~name");
	}
	catch(ParmSyntaxErrException e)
	{
	    return;
	}
	
	fail("Should not have been able to destroy!");
    }
    public void testRemoveBadparam()
	throws Exception
    {
	try
	{
	    smapi.nameListRemove("bad~name~list~name", "bad~user~name");
	}
	catch(ParmSyntaxErrException e)
	{
	    return;
	}
	
	fail("Should not have been able to destroy!");
    }
	
    public void testGoodAdd()
	throws Exception
    {
	//Ensure that the list does not already exist
	try
	{
	    smapi.nameListDestroy("TheGoodList");
	}
	catch (ListNotFoundException e)
	{
	}
	
	int f=smapi.nameListAdd("TheGoodList", "LIVET000");
	assertTrue(f== SMAPI_Interface.NL_LISTMADE_GUESTADDED); 
	
	int r=smapi.nameListAdd("TheGoodList", "LIVET001");
	assertTrue(r==SMAPI_Interface.NL_GUESTADDED);
	
	int r2=smapi.nameListAdd("TheGoodList", "LIVET001");
	assertTrue(r2==SMAPI_Interface.NL_LISTMADE_GUESTTHERE);
	
	int d=smapi.nameListRemove("TheGoodList", "LIVET000");
	//assertTrue(d==2);
    }    
    public void testGoodQuery()
	throws Exception
    {
	//Ensure that the list does not already exist
	try
	{
	    smapi.nameListDestroy("TheGoodList");
	}
	catch (ListNotFoundException e)
	{
	}
	
	int f=smapi.nameListAdd("TheGoodList", "LIVET000");
	LinkedList lst = smapi.nameListQuery("TheGoodList");
	assertTrue(lst.size()==1); //FAILING
	assertTrue(lst.contains("LIVET000"));
	f=smapi.nameListRemove("TheGoodList", "LIVET000");
    }
	
    public void testGoodDestroy()
	throws Exception
    {
	int f=smapi.nameListAdd("TheGoodList", "LIVET000");
	smapi.nameListDestroy("TheGoodList");
	try
	{
	    LinkedList lst = smapi.nameListQuery("TheGoodList");
	}
	catch (ListNotFoundException e)
	{
	    return;
	}
	fail("Should not have been able to find destroyed list");
    }
 
	
	public void testNamelistQueryAll()
	{
		try {
			try
			{
				smapi.nameListDestroy("TheGoodList");
			}
			catch (ListNotFoundException e)
			{
			}
			
			int f=smapi.nameListAdd("TheGoodList", "LIVET000");
			assertEquals(f, SMAPI_Interface.NL_LISTMADE_GUESTADDED); 
			
			int r=smapi.nameListAdd("TheGoodList", "LIVET001");
			assertEquals(r, SMAPI_Interface.NL_GUESTADDED);
			
			LinkedList lists = smapi.nameListQueryAll();
			
			Iterator iter = lists.iterator();
			while(iter.hasNext())
			{
				NameList list = (NameList) iter.next();
				
				if(list.getListName().equals("THEGOODLIST"))
				{
					Iterator iter2 = list.iterator();
					boolean found_0 = false, found_1 = false;
					
					while(iter2.hasNext())
					{
						String element = (String) iter2.next();
						if(element.equals("LIVET000"))
							found_0 = true;
						if(element.equals("LIVET001"))
							found_1 = true;
					}
					
					assertTrue(found_0);
					assertTrue(found_1);
					assertEquals(list.getElements().size(), 2);
					
					return;
				}
			}
			
			fail("TheGoodList not present in list of name lists");
		}
		catch(Throwable e) {
			fail("Exception thrown: " + e.toString());
		}
	}
}
