package live.test.smapi;

import junit.framework.*;
import java.util.ListIterator;
import java.util.LinkedList;

import live.smapi.SMAPI_Interface;
import live.smapi.exceptions.*;

/* Assumptions being made:
 *
 * - Username, password, ip, and port are fixed.
 * - No user named NONAME
 *
 */

public class testMisc extends TestCase
{

    SMAPI_Interface smapi;
    SMAPI_Interface smapiBad;
    
    protected void setUp()
    {
	smapi = new SMAPI_Interface("9.60.9.216", 44444, "VSMSTEVE", "SS4VSM");
	smapiBad = new SMAPI_Interface("9.60.9.216", 44444, "NONAME", "NOPASS");
    }

    protected void tearDown()
    {
	/* Need not do anything here :) */
    }

    public static void main(String args[])
    {
	junit.textui.TestRunner.run(suite());
    }
    
    public static Test suite()
    {
	return new TestSuite(testMisc.class);
    }
    
    public void testNullRequest()
	throws Exception
    {
	smapi.nullRequest();
    }
    
    public void testNullRequestFail()
	throws SMAPIException
    {
	try { smapiBad.nullRequest(); }
	catch(RequestNotAuthorizedException e)
	{
	    return;
	}
	fail("Should NOT have been able to log in!");   
    }
    public void testFindAddressBad()
       throws SMAPIException
    {
	try {String i = smapi.getLowestFreeAddress("BADUSER", "3");}
	catch(ImageNotFoundException e )
	{
	    return;
	}
	fail("Should NOT have found BADUSER");	
    }
    public void testFindAddress()
	throws SMAPIException
    {
	String i = smapi.getLowestFreeAddress("STEVE2", "3");
	
	assertTrue(i != " ");
    }
    /*
    public void testQueryVirtual()
	throws SMAPIException
    {
	LinkedList virtadd = smapi.returnQueryVirtual("steve2");
	System.out.println(virtadd.toString());
    }
     */
 /*    public void testFindStorage()
	throws SMAPIException
    {
	String i = smapi.getLowestFreeStorage("STEVE2", "3");
	assertTrue(i != " ");
    }
  */
}