package live.test.smapi;

import junit.framework.*;
import java.util.ListIterator;
import java.util.LinkedList;
import java.util.Iterator;

import live.smapi.SMAPI_Interface;
import live.smapi.exceptions.*;
import live.dto.Network;

import live.dto.NameList;
/* Assumptions being made:
 *
 * - Username, password, ip, and port are fixed.
 * - OPERATOR guest exists.
 * - OPERATOR is logged on.
 * - GuestLAN LIVELAN does not exist.
 * - OPERATOR vdev 760-763 are not used.
 */

public class testLANs extends TestCase
{
    SMAPI_Interface smapi;
    
    protected void setUp()
    {
	smapi = new SMAPI_Interface("9.60.9.216", 44444, "VSMSTEVE", "SS4VSM");
    }

    protected void tearDown()
    {
	/* Need not do anything here :) */
    }

    public static void main(String args[])
    {
	junit.textui.TestRunner.run(suite());
    }
    
    public static Test suite()
    {
	return new TestSuite(testLANs.class);
    }
/*    
    public void testCreateQueryDeleteGuestLAN()
	throws Exception
    {
	
	int i = smapi.virtualLANCreateAndConnect("LIVELAN", "STEVE2");
	assertTrue(i==0 || i==1 || i==2);
	LinkedList networks = smapi.virtualLanQuery();
	Network curNet;
	boolean foundLIVELAN = false;
	
	ListIterator itr = networks.listIterator();
	while(itr.hasNext() && foundLIVELAN == false)
	{
	    curNet = (Network)itr.next();
	    if(curNet.getNetworkName().equals("LIVELAN") && curNet.getNetworkType() == Network.NETWORK_GLAN)
		foundLIVELAN = true;
	    
	}

	if (!foundLIVELAN) fail("Should have found LIVELAN!");
	
	i = smapi.virtualLANDisconnectAndDelete("LIVELAN", "OPERATOR", "760");
	assertTrue(i==0 || i==1 || i==2);
     }
 */
/*    public void testqueryNetworks()
	throws Exception
    {
	try {
	    try
	    {
	    	smapi.nameListDestroy("TheGoodList");
	    }
	    catch (ListNotFoundException e)
	    {
	    }
			
	    int f=smapi.nameListAdd("TheGoodList", "NiceUsur");
	    assertEquals(f, SMAPI_Interface.NL_LISTMADE_GUESTADDED); 
			
	    int r=smapi.nameListAdd("TheGoodList", "USER2");
	    assertEquals(r, SMAPI_Interface.NL_GUESTADDED);
	    
	    LinkedList lists = smapi.queryNetworkMembers("ALL");
			
	    Iterator iter = lists.iterator();
	    while(iter.hasNext())
	    {
	    	NameList list = (NameList) iter.next();
				
		if(list.getListName().equals("THEGOODLIST"))
		{
		    Iterator iter2 = list.iterator();
		    boolean found_NiceUsur = false, found_USER2 = false;
					
		    while(iter2.hasNext())
		    {
			String element = (String) iter2.next();
			if(element.equals("NICEUSUR"))
			found_NiceUsur = true;
			if(element.equals("USER2"))
			found_USER2 = true;
		    }
					
		    assertTrue(found_NiceUsur);
		    assertTrue(found_USER2);
		    assertEquals(list.getElements().size(), 2);
		    
		    return;
	    	}
	   }
			
	    fail("TheGoodList not present in list of name lists");
	    }
		catch(Throwable e) {
			fail("Exception thrown: " + e.toString());
		}
	
    }
*/	
/*
    public void testLANInactiveImage()
	throws Exception
     {
	try
	{
	    int i = smapi.virtualLANCreateAndConnect("BADLANDS", "IMANAR", "0F40");
	}
	catch(ImageNotActiveException e)
	{
	    return;
	}
	fail("Should not have found an image");
     }
 */
 /* we'll uncomment this later, after we have implemented activate/deactivate images
     public void testLANInactiveImage()
	throws Exception
     {
	try
	{
	    int i = smapi.virtualLANCreateAndConnect("BADLANDS", "INACTIVE", "0F40");
	}
	catch(ImageNotActiveException e)
	{
	    return;
	}
	
	fail("Should not have found an image");
     }
*/   
 /* we'll uncomment this later, after we have implemented lock/unlock images
     public void testLANInactiveImage()
	throws Exception
     {
	try
	{
	    int i = smapi.virtualLANCreateAndConnect("BADLANDS", "LOCKEDIM", "0F40");
	}
	catch(ImageLockedException e)
	{
	    return;
	}
	
	fail("Should not have found an image");
     }
*/    
     
/*     
     public void testVaddrInUse()
	throws Exception
     {
	 try
	 {
	     int i = smapi.virtualLANCreateAndConnect("NEWAINA", "VSMSTEVE", "0F00");
	 }
	 catch (ImageDeviceDefinedException e)
	 {
	     return;
	 }
	 fail("Should have gotten a ImageDeviceDefinedException!");
     }
 */
    
    public void testCreateNewCreate()
	throws Exception
    {
	smapi.virtualLANCreate("LIVELAN");
	int i;
	try
	{
	    i = smapi.virtualLANCreateAndConnect("LIVELAN", "LIVET000");
	    assertTrue(i==0 || i==1 || i==2);
	    
	}
	catch(ImageNotActiveException e)
	{
	    //Is ok if guest is not logged on.
	}
	
	try
	{
	    i = smapi.virtualLANCreateAndConnect("LIVELAN", "LIVET001");
	    assertTrue(i==0 || i==1 || i==2);
	}
	catch(ImageNotActiveException e)
	{
	    //Is ok if guest is not logged on.
	}
	
	LinkedList networks = smapi.virtualLanQuery();
	Network curNet;
	boolean foundNet = false;
	
	ListIterator itr = networks.listIterator();
	while(itr.hasNext() && foundNet == false)
	{
	    curNet = (Network)itr.next();
		    
	    if(curNet.getNetworkName().equals("LIVELAN") && curNet.getNetworkType() == Network.NETWORK_GLAN)
		foundNet = true;
	}
	if (!foundNet) fail("Should have found LIVELAN!");
	
	/* test switch already exist case*/
	boolean ex = false;
	try
	{
	    smapi.virtualLANCreate("LIVELAN");
	}
	catch(LANAlreadyExistsException e)
	{
	    ex = true;
	}
	if(!ex) fail("Should have thrown a vswitch already exists exception!");
	
	
	try
	{
	    i = smapi.virtualLANDisconnectAndDelete("LIVET000", "LIVELAN", "000F");
	    assertTrue(i==0 || i==1 || i==2);
	}
	catch(ImageNotActiveException e)
	{
	    //Is ok if guest is not logged on.
	}
	
	try
	{
	    i = smapi.virtualLANDisconnectAndDelete("LIVET001", "LIVELAN", "000f");
	    assertTrue(i==0 || i==1 || i==2);
	}
	catch(ImageNotActiveException e)
	{
	    //Is ok if guest is not logged on.
	}
    }

}
