package live.test.smapi;

import junit.framework.*;
import java.util.ListIterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

import live.smapi.SMAPI_Interface;
import live.smapi.exceptions.*;

/* Assumptions being made:
 *
 * - Username, password, ip, and port are fixed.
 * - OPERATOR guest exists.
 *
 */

public class testImages extends TestCase
{
    SMAPI_Interface smapi;
    
    protected void setUp()
    {
	smapi = new SMAPI_Interface("9.60.9.216", 44444, "VSMSTEVE", "SS4VSM");
    }

    protected void tearDown()
    {
	/* Need not do anything here :) */
    }

    public static void main(String args[])
    {
	junit.textui.TestRunner.run(suite());
    }
    
    public static Test suite()
    {
	return new TestSuite(testImages.class);
    }
   
    public void testImageDiskCopy()
	throws Exception
    {	
	try  {smapi.imageDiskDeleteDM("LIVET000", "0636"); smapi.imageDiskDelete("LIVET000", "0636");}
	catch (SMAPIException e) {}
	
	int i = smapi.imageDiskCopyDM("LIVET000", "0636", "MAINT", "0CF1", "AUTOG", "MR", "&", "&", "&");
	System.out.println(i);
    }
    
   
    public void testQueryNames()
	throws Exception
    {
	LinkedList lst = smapi.imageNameQuery();

	ListIterator itr = lst.listIterator();
	while(itr.hasNext())
	{
	    if( ((String)itr.next()).equals("OPERATOR") ) return;
	}
	
	fail("Should have found OPERATOR!");
    }
 
    public void testImageQuery()
	throws Exception
    {
	LinkedList lst = smapi.imageQuery("OPERATOR");
	
	StringTokenizer strTok = new StringTokenizer((String)lst.get(0));
	
	assertTrue(strTok.hasMoreTokens());
	assertTrue(strTok.nextToken().equals("USER"));
	assertTrue(strTok.hasMoreTokens());
	assertTrue(strTok.nextToken().equals("OPERATOR"));
	
    }
    public void testImageQuerybad()
	throws Exception
    {
	try
	{
	    LinkedList lst = smapi.imageQuery("BADUSER");
	}
	catch (ImageDefNotFoundException e)
	{
	    return;
	}
	fail("Should not have found BADUSER");
    }
	public void testActiveImagesQuery()
	{
		try {
			LinkedList list = smapi.activeImagesQuery();
			
			boolean found_steve1 = false, found_off = true;
			
			ListIterator iter = list.listIterator();
			while(iter.hasNext())
			{
				String name = (String) iter.next();
				
				if(name.equals("STEVE1")) found_steve1 = true;
				if(name.equals("OFF"))    found_off    = true;
			}
			
			assertTrue(found_steve1);
			assertTrue(found_off);
		}
		catch(Throwable e) {
			fail("Exception thrown: " + e);
		}
	}
	/*
	public void testImageDelete()
	{   
	    try
	    {
		smapi.imageDelete("EMILY");
	    }
	    catch(Throwable e)
	    {
		fail("Exception thrown: " + e);
	    }
	}
 
	*/
    
	public void testbadImageDelete()
	    throws Exception
	{
	    try
	    {
		smapi.imageDelete("BADIMAGE");
	    }
	    catch(ImageDefNotFoundException e)
	    {
		return;
	    }
	    fail("Should not have been able to delete BADIMAGE");
	}
	public void testImageActivate()
	    throws Exception
	{
	    try
	    {
		try {	smapi.imageActivate("LIVET000"); } catch (SMAPIException e) {}
		smapi.imageDeactivate("LIVET000");
		smapi.imageActivate("LIVET000");
	    }
	    catch (Throwable e)
	    {
		fail("Exception thrown:" + e);
	    }
	}
    public void testImageActivateBad()
	    throws Exception
	{
	    try
	    {
		smapi.imageDeactivate("BADUSER");
	    }
	    catch (ImageNotActiveException e)
	    {
		try
		{
		    smapi.imageActivate("BADUSER");
		}
		catch (ImageNotFoundException f)
		{
		    return;
		}
	    }
	}
    public void testChangeImagePassword()
	throws Exception
    {
	smapi.imageSetPassword("LIVET000", "newtest");
	smapi.imageSetPassword("LIVET000", "test");
	smapi.imageSetPassword("LIVET001", "test");
    }
    public void testImageCreateQueryDelete()
	throws Exception
    {
	//Ensure test guest does not exist already
	try{ smapi.imageDelete("LIVEG00"); }
	catch(ImageDefNotFoundException e) { }
	
	//Make sure our profile exists
	LinkedList lines = new LinkedList();
	lines.add("USER TESTP XXXXXXXX 128M 128M ABCDEFGHIJKLMNOPQRSTUVWXYZ"); /* 56 */
    
	lines.add("IPL CMS");
	try { smapi.prototypeCreate("TESTP2", lines); }
	catch(PrototypeAlreadyExistsException e) { }
	
	//Create guest
	smapi.imageCreate("LIVEG00", "TESTP2", "PASS");
	
	//Query that the guest exists
	smapi.imageQuery("LIVEG00");
	
	//Delete the guest
	smapi.imageDelete("LIVEG00");
    }
    
    public void testImageDiskCreateDelete()
	throws Exception
    {
	try {smapi.imageDiskDeleteDM("LIVET000", "3433");}
	catch (SMAPIException e) {}
	smapi.imageDiskCreateDM("LIVET000", "3433", "AUTOG", " ", "3", "WR", "NONE", "test", "test", "test");
	smapi.imageDiskDeleteDM("LIVET000", "3433");
	
    }
  


}