package live.test.dto;

import junit.framework.*;
import java.util.ListIterator;

import live.dto.Group;

public class testGroup extends TestCase
{
    Group group;

    protected void setUp()
    {
	group = new Group("GROUPA");
    }

    protected void tearDown()
    {
	/* Need not do anything here :) */
    }

    public static void main(String args[])
    {
	junit.textui.TestRunner.run(suite());
    }

    public static Test suite()
    {
	return new TestSuite(testGroup.class);
    }

    public void testName()
    {
	assertTrue(group.getGroupName().equals("GROUPA"));

	group.setGroupName("GROUPB");
	assertTrue(group.getGroupName().equals("GROUPB"));
    }	

    public void testFind()
    {
	/* Test case where list is empty. */
	int index = group.findMember("GUESTA");
	assertTrue(index == -1);
	
	group.addMember("GUESTA");
	group.addMember("GUESTB");
	group.addMember("GUESTC");
	
	index = group.findMember("GUESTB");
	assertTrue(index == 1);
	
	index = group.findMember("NOTTHERE");
	assertTrue(index == -1);
	
    }
    
   public void testAddRemove()
   {
	group = new Group("GROUPA");
	
	group.addMember("GUESTA");
	group.addMember("GUESTB");
	group.addMember("GUESTC");
	
	ListIterator itr = group.getMembers();
	
	assertTrue(itr.hasNext());  itr.next();
	assertTrue(itr.hasNext());  itr.next();
	assertTrue(itr.hasNext());  itr.next();
	assertTrue(!itr.hasNext());
	
	group.removeMember(0);
	group.removeMember("GUESTC");
	group.removeMember(0);
	
	itr = group.getMembers();
	assertTrue(!itr.hasNext());
   }

}
