/*
 * testCache.java
 * Created on June 13, 2005, 3:18 PM
 */

package live.test.cache;

import junit.framework.*;
import live.cache.Cache;
import java.util.ListIterator;
import java.util.LinkedList;
import live.dto.Guest;
import live.dto.Network;
import live.dto.Group;
import live.dto.SavedSegment;

public class testCache extends TestCase
{
    Cache cache;

    protected void setUp()
    {
	cache = new Cache("",1,"","");
    }

    protected void tearDown()
    {
	/* Need not do anything here :) */
    }

    public static void main(String args[])
    {
	junit.textui.TestRunner.run(suite());
    }

    public static Test suite()
    {
	return new TestSuite(testCache.class);
    }

    public void testGuestAdd()
    {
	cache.addGuest("GUESTA");
	cache.addGuest("GUESTB", "GROUPX");
	
	ListIterator itr = cache.getGuests();
	assertTrue(itr.hasNext());
	
	Guest current = (Guest)itr.next();
	assertTrue(current.getGuestName().equals("GUESTA"));
	assertTrue(current.getGroupName() == null);
	
	assertTrue(itr.hasNext());
	current = (Guest)itr.next();
	assertTrue(current.getGuestName().equals("GUESTB"));
	assertTrue(current.getGroupName().equals("GROUPX"));
	
	assertTrue(!itr.hasNext());
    }

    public void testGuestRemoveByObject()
    {
	cache = new Cache("",1,"","");
	
	cache.addGuest("GUESTA");
	cache.addGuest("GUESTB", "GROUPX");
	cache.addGuest("GUESTC", "GROUPX");
	
	//Does it have atleast one member?
	ListIterator itr = cache.getGuests();
	assertTrue(itr.hasNext());
	
	//Removing a member (should have 2 members now)
	cache.removeGuest((Guest)itr.next());
	itr = cache.getGuests();
	
	//Member 1?
	assertTrue(itr.hasNext());
	Guest current = (Guest)itr.next();
	
	//Member 2?
	assertTrue(itr.hasNext());
	current = (Guest)itr.next();
	
	//Removing a member (Should have 1 member now)
	cache.removeGuest(current);
	itr = cache.getGuests();
	
	//member 1?
	assertTrue(itr.hasNext());
	current = (Guest)itr.next();
	
	//Removing last memner (0 left)
	cache.removeGuest(current);
	itr = cache.getGuests();
	
	//Should not have any members left.
	assertTrue(!itr.hasNext());
	
    }

    public void testGuestRemoveByName()
    {
	cache = new Cache("",1,"","");
	
	cache.addGuest("GUESTA");
	cache.addGuest("GUESTB", "GROUPX");
	cache.addGuest("GUESTC", "GROUPX");
	
	cache.removeGuest("GUESTB");
	
	ListIterator itr = cache.getGuests();
	assertTrue(itr.hasNext());
	Guest current = (Guest)itr.next();
	
	assertTrue(itr.hasNext());
	current = (Guest)itr.next();
	
	cache.removeGuest("GUESTC");
	
	itr = cache.getGuests();
	assertTrue(itr.hasNext());
	current = (Guest)itr.next();
	
	cache.removeGuest("GUESTA");
	
	itr = cache.getGuests();
	assertTrue(!itr.hasNext());
	
    }
    
    public void testChangeGuestGroup()
    {
	Cache c = new Cache("",1,"","");
	
	c.addGuest("GUESTA", "GRP1");
	c.addGuest("GUESTB");
	c.addGuest("GUESTC");
	
	c.changeGuestsGroup("GUESTB", "NEWGROUP");
	
	ListIterator itr = c.getGuests();
	
	boolean found = false;
	Guest current;
	while(itr.hasNext())
	{
	    current = (Guest)itr.next();
	    if(current.getGroupName() != null)
	    	if(current.getGroupName().equals("NEWGROUP")) found = true;
	}
	
	assertTrue(found);
    }
    
    public void testGetGroupNamesSimple()
    {
	Cache c = new Cache("",1,"","");
	
	LinkedList lst = c.getGroupNames();
	
	
	/* List should have 0 elements */
	assertTrue(lst.size() == 0);
	
	/* List should NOT contain anything*/
	assertTrue(findInStringList(lst, "GRP1") == -1);
	assertTrue(findInStringList(lst, "GRP2") == -1);
	assertTrue(findInStringList(lst, "GRP3") == -1);
	assertTrue(findInStringList(lst, "GRP4") == -1);
	assertTrue(findInStringList(lst, "GRP5") == -1);
	assertTrue(findInStringList(lst, "GRP0") == -1);
	assertTrue(findInStringList(lst, "GRP6") == -1);
	assertTrue(findInStringList(lst, null) == -1);
    }
    
    public void testGetGroupNames()
    {
	Cache c = new Cache("",1,"","");
	c.addGuest("GUESTA", "GRP1");
	c.addGuest("GUESTB");
	c.addGuest("GUESTC");
	c.addGuest("GUESTD", "GRP2");
	c.addGuest("GUESTE", "GRP3");
	c.addGuest("GUESTF", "GRP3");
	c.addGuest("GUESTG", "GRP4");
	c.addGuest("GUESTG", "GRP5");
	
	LinkedList lst = c.getGroupNames();
	
	/* List should have 5 elements */
	assertEquals(5, lst.size());
	
	/* List should contain GRP1 - GRP5*/
	assertTrue(findInStringList(lst, "GRP1") != -1);
	assertTrue(findInStringList(lst, "GRP2") != -1);
	assertTrue(findInStringList(lst, "GRP3") != -1);
	assertTrue(findInStringList(lst, "GRP4") != -1);
	assertTrue(findInStringList(lst, "GRP5") != -1);
	
	assertTrue(findInStringList(lst, "GRP0") == -1);
	assertTrue(findInStringList(lst, "GRP6") == -1);
	assertTrue(findInStringList(lst, null) == -1);
    }
    
    public void testGetGuestsInGroup()
    {
	Cache c = new Cache("",1,"","");
	c.addGuest("GUESTA", "GRP1");
	c.addGuest("GUESTB", "GRP2");
	c.addGuest("GUESTC", "GRP3");
	c.addGuest("GUESTD", "GRP3");
	c.addGuest("GUESTE", "GRP2");
	c.addGuest("GUESTF", "GRP3");
	c.addGuest("GUESTG", "GRP2");
	c.addGuest("GUESTH", "GRP1");
	c.addGuest("GUESTI", "GRP1");
	c.addGuest("GUESTJ", "GRP1");
	
	LinkedList list1 = c.getGuestsInGroup("GRP1");
	LinkedList list1Str = new LinkedList();
	assertTrue(list1.size() == 4);
	list1Str.add(((Guest)list1.get(0)).getGuestName());
	list1Str.add(((Guest)list1.get(1)).getGuestName());
	list1Str.add(((Guest)list1.get(2)).getGuestName());
	list1Str.add(((Guest)list1.get(3)).getGuestName());
	assertTrue(findInStringList(list1Str, "GUESTA") != -1);
	assertTrue(findInStringList(list1Str, "GUESTH") != -1);
	assertTrue(findInStringList(list1Str, "GUESTI") != -1);
	assertTrue(findInStringList(list1Str, "GUESTJ") != -1);
	
	LinkedList list2 = c.getGuestsInGroup("GRP2");
	LinkedList list2Str = new LinkedList();
	assertTrue(list2.size() == 3);
	list2Str.add(((Guest)list2.get(0)).getGuestName());
	list2Str.add(((Guest)list2.get(1)).getGuestName());
	list2Str.add(((Guest)list2.get(2)).getGuestName());
	assertTrue(findInStringList(list2Str, "GUESTB") != -1);
	assertTrue(findInStringList(list2Str, "GUESTE") != -1);
	assertTrue(findInStringList(list2Str, "GUESTG") != -1);
	
	LinkedList list3 = c.getGuestsInGroup("GRP3");
	LinkedList list3Str = new LinkedList();
	assertTrue(list3.size() == 3);
	list3Str.add(((Guest)list3.get(0)).getGuestName());
	list3Str.add(((Guest)list3.get(1)).getGuestName());
	list3Str.add(((Guest)list3.get(2)).getGuestName());
	assertTrue(findInStringList(list3Str, "GUESTC") != -1);
	assertTrue(findInStringList(list3Str, "GUESTD") != -1);
	assertTrue(findInStringList(list3Str, "GUESTF") != -1);
	
	LinkedList list0 = c.getGuestsInGroup("NOFIND");
	assertTrue(list0.size() == 0);
    }
    
    public void testGetGroupsSimple()
    {
	Cache c = new Cache("",1,"","");
	
	LinkedList lst = c.getGroups();
	ListIterator itr = lst.listIterator();
	assertTrue(!itr.hasNext());
	
    }
    
    public void testGetGroups()
    {
	Cache c = new Cache("",1,"","");
	c.addGuest("GUESTA", "GRP1");
	c.addGuest("GUESTB", "GRP2");
	c.addGuest("GUESTC", "GRP3");
	c.addGuest("GUESTD", "GRP3");
	c.addGuest("GUESTE", "GRP2");
	c.addGuest("GUESTF", "GRP3");
	c.addGuest("GUESTG", "GRP2");
	c.addGuest("GUESTH", "GRP1");
	c.addGuest("GUESTI", "GRP1");
	c.addGuest("GUESTJ", "GRP1");
	
	LinkedList groupsList = c.getGroups();
	ListIterator groupsIterator = groupsList.listIterator();

	/* Ensure all 3 groups are represented in this list. */
	assertTrue(groupsList.size() == 3);
	LinkedList groupsListStr = new LinkedList();
	groupsListStr.add(((Group)groupsList.get(0)).getGroupName());
	groupsListStr.add(((Group)groupsList.get(1)).getGroupName());
	groupsListStr.add(((Group)groupsList.get(2)).getGroupName());
	int indexGRP1 = findInStringList(groupsListStr, "GRP1");
	int indexGRP2 = findInStringList(groupsListStr, "GRP2");
	int indexGRP3 = findInStringList(groupsListStr, "GRP3");
	assertTrue(indexGRP1 != -1);
	assertTrue(indexGRP2 != -1);
	assertTrue(indexGRP3 != -1);
	
	/* Ensure GRP1 has correct members */
	assertTrue( ((Group)groupsList.get(indexGRP1)).findMember("GUESTA") != -1 );
	assertTrue( ((Group)groupsList.get(indexGRP1)).findMember("GUESTH") != -1 );
	assertTrue( ((Group)groupsList.get(indexGRP1)).findMember("GUESTI") != -1 );
	assertTrue( ((Group)groupsList.get(indexGRP1)).findMember("GUESTJ") != -1 );
	
	/* Ensure GRP2 has correct members */
	assertTrue( ((Group)groupsList.get(indexGRP2)).findMember("GUESTB") != -1 );
	assertTrue( ((Group)groupsList.get(indexGRP2)).findMember("GUESTE") != -1 );
	assertTrue( ((Group)groupsList.get(indexGRP2)).findMember("GUESTG") != -1 );
	assertTrue( ((Group)groupsList.get(indexGRP2)).findMember("GUESTJ") == -1 );
	
	/* Ensure GRP3 has correct members */
	assertTrue( ((Group)groupsList.get(indexGRP3)).findMember("GUESTC") != -1 );
	assertTrue( ((Group)groupsList.get(indexGRP3)).findMember("GUESTD") != -1 );
	assertTrue( ((Group)groupsList.get(indexGRP3)).findMember("GUESTF") != -1 );
	assertTrue( ((Group)groupsList.get(indexGRP3)).findMember("GUESTB") == -1 );
    }
    
    public void testNetworkAddAndGet()
    {
	Cache c = new Cache("",1,"","");
	c.addNetwork("GLAN1",  Network.NETWORK_GLAN);
	c.addNetwork("VSWITCH1",  Network.NETWORK_VSWITCH);
	c.addNetwork("GLAN2",  Network.NETWORK_GLAN);
	c.addNetwork("VSWITCH2",  Network.NETWORK_VSWITCH);
	c.addNetwork("VSWITCH3",  Network.NETWORK_VSWITCH);
	
	ListIterator itr = c.getNetworks();
	
	Network curNet = (Network)itr.next();
	assertTrue(curNet.getNetworkName().equals("GLAN1"));
	assertTrue(curNet.getNetworkType() == Network.NETWORK_GLAN);
	curNet = (Network)itr.next();
	assertTrue(curNet.getNetworkName().equals("VSWITCH1"));
	assertTrue(curNet.getNetworkType() == Network.NETWORK_VSWITCH);
	curNet = (Network)itr.next();
	assertTrue(curNet.getNetworkName().equals("GLAN2"));
	assertTrue(curNet.getNetworkType() == Network.NETWORK_GLAN);
	curNet = (Network)itr.next();
	assertTrue(curNet.getNetworkName().equals("VSWITCH2"));
	assertTrue(curNet.getNetworkType() == Network.NETWORK_VSWITCH);
	curNet = (Network)itr.next();
	assertTrue(curNet.getNetworkName().equals("VSWITCH3"));
	assertTrue(curNet.getNetworkType() == Network.NETWORK_VSWITCH);
	
	assertTrue(!itr.hasNext());
    }
    
    public void testNetworkRemove()
    {
	Cache c = new Cache("",1,"","");
	c.addNetwork("GLAN1",  Network.NETWORK_GLAN);
	c.addNetwork("VSWITCH1",  Network.NETWORK_VSWITCH);
	c.addNetwork("GLAN2",  Network.NETWORK_GLAN);
	c.addNetwork("VSWITCH2",  Network.NETWORK_VSWITCH);
	c.addNetwork("VSWITCH3",  Network.NETWORK_VSWITCH);
	
	c.removeNetwork("GLAN2");
	c.removeNetwork("VSWITCH2");
	
	ListIterator itr = c.getNetworks();
	
	Network curNet = (Network)itr.next();
	assertTrue(curNet.getNetworkName().equals("GLAN1"));
	assertTrue(curNet.getNetworkType() == Network.NETWORK_GLAN);
	curNet = (Network)itr.next();
	assertTrue(curNet.getNetworkName().equals("VSWITCH1"));
	assertTrue(curNet.getNetworkType() == Network.NETWORK_VSWITCH);
	curNet = (Network)itr.next();
	assertTrue(curNet.getNetworkName().equals("VSWITCH3"));
	assertTrue(curNet.getNetworkType() == Network.NETWORK_VSWITCH);
	
	assertTrue(!itr.hasNext());
    }
    
    public void testSavedSegmentAddAndGet()
    {
	Cache c = new Cache("",1,"","");
	c.addSavedSegment("SS1");
	c.addSavedSegment("SS2");
	c.addSavedSegment("SS3");
	c.addSavedSegment("SS4");
	c.addSavedSegment("SS5");
	
	ListIterator itr = c.getSavedSegments();
	
	SavedSegment curSS = (SavedSegment)itr.next();
	assertTrue(curSS.getName().equals("SS1"));
	curSS = (SavedSegment)itr.next();
	assertTrue(curSS.getName().equals("SS2"));
	curSS = (SavedSegment)itr.next();
	assertTrue(curSS.getName().equals("SS3"));
	curSS = (SavedSegment)itr.next();
	assertTrue(curSS.getName().equals("SS4"));
	curSS = (SavedSegment)itr.next();
	assertTrue(curSS.getName().equals("SS5"));
		
	assertTrue(!itr.hasNext());
    }
    
    public void testSavedSegmentRemove()
    {
	Cache c = new Cache("",1,"","");
	c.addSavedSegment("SS1");
	c.addSavedSegment("SS2");
	c.addSavedSegment("SS3");
	c.addSavedSegment("SS4");
	c.addSavedSegment("SS5");
	
	c.removeSavedSegment("SS3");
	c.removeSavedSegment("SS5");
	
	ListIterator itr = c.getSavedSegments();
	
	SavedSegment curSS = (SavedSegment)itr.next();
	assertTrue(curSS.getName().equals("SS1"));
	curSS = (SavedSegment)itr.next();
	assertTrue(curSS.getName().equals("SS2"));
	curSS = (SavedSegment)itr.next();
	assertTrue(curSS.getName().equals("SS4"));
		
	assertTrue(!itr.hasNext());
    }
    
    public void testClearSavedSegments()
    {
	Cache c = new Cache("",1,"","");
	c.addSavedSegment("SS1");
	c.addSavedSegment("SS2");
	c.addSavedSegment("SS3");
	c.addSavedSegment("SS4");
	c.addSavedSegment("SS5");
	
	c.clearSavedSegments();
	
	ListIterator itr = c.getSavedSegments();
	assertTrue(!itr.hasNext());
    }
    
    
    /*************** PRIVATE ***************/
    
    /**
     * Given a list of Strings, this function will return the index at which it 
     * finds strToFind in the list, or 01 if it does not find it.
     *
     * @param	list The list to search.
     * @param	strToFind The string we wish to find in the list we are searching.
     * @return	index if we find the string in the list, -1 otherwise.
     */
    private int findInStringList(LinkedList list, String strToFind)
    {
	/* If the String to find is NULL, no need to even look. */
	if(strToFind == null) return -1;
	
	String curStr;
	
	int max = list.size();
	for(int i=0; i < max; i++)
	{
	    curStr = (String)list.get(i);
	    if (curStr.equals(strToFind)) return i;
	}

	return -1;
    }
}
