/*
 * ZVMTasksException.java
 * Created on June 14, 2005, 3:13 PM
 */

package live.zvmtasks;

/**
 * An exception that the ZVMTasks library throws in the event of an 
 * unrecoverable error.
 *
 * @author Jason J. Herne
 */
public class ZVMTasksException extends java.lang.Exception
{
    /**
     * Constructs an instance of <code>ZVMTasksException</code> with the specified detail message.
     * @param msg the detail message.
     */
    public ZVMTasksException(String msg)
    {
	super(msg);
    }
    
    /**
     * Constructs an instance of <code>ZVMTasksException</code> with the specified exception
     * @param t The exception to throw
     */
    public ZVMTasksException(Throwable t)
    {
	super(t.getMessage(), t);
    }
    
    /**
     * Constructs an instance of <code>ZVMTasksException</code> with the specified message and exception
     * @param msg Detail message
     * @param t The exception to throw
     */
    public ZVMTasksException(String msg, Throwable t)
    {
	super(msg, t);
    }
    
}
