package live.threads;

import java.util.LinkedList;

/**
 * This class was created solely for testing purposes, and is essentially useless for anything but that
 */
public class WaitAction extends ThreadedUserAction
{
	private int wait;
	
	public WaitAction(ThreadInitInfo connectionInfo, double secToLive)
	{
		init(connectionInfo);
		wait = (int)(secToLive * 1000); //sec -> ms
	}
	
	
	protected void   runImpl()
	{
		try
		{
			sleep(wait);
		}
		catch(InterruptedException e) 
		{
			/* This should not happen unless something really weird is going on,
			 * because threads should never be interrupted in this program, ever.
			 * The closest thing is when the user request thread creates an action
			 * thread and joins it, if the join times out. And I don't know if that
			 * throws the exception or not. But we should never wake up a sleeping
			 * thread.
			 *
			 * This catch is here simply to make the compiler not complain.
			 */
		}
	}
	
	public String description()
	{
		return "Waiting " + wait;
	}
	
	public String result()
	{
		return "Finished";
	}
	
	private LinkedList tasks = null;
	
	public Object rawResult()
	{
		return tasks;
	}
}
