package live.threads;

import live.dto.ConnectionInfo;
import live.cache.Cache;

/**
 * This class holds information that is needed by a thread in order to start.
 * ThreadedUserAction creates a ZVMTasks object for its subclasses to use, and
 * the {@link live.dto.ConnectionInfo} object holds the parameters that needs
 * to initialize. The {@link ActiveThreadsInfo} object is used for tracking.
 * 
 * @author Evan Driscoll
 */
public class ThreadInitInfo
{
	private ConnectionInfo connection;
	private ActiveThreadsInfo threads;
	private Cache cache;
	
	/**
	 * Creates a new ThreadInitInfo object
	 * @param connectionInfo User Name, Password, PortName, etc needed to open a socket
	 * @param threadsInfo Information about the active threads
	 * @param cache The current cache
	 */
	public ThreadInitInfo(ConnectionInfo connectionInfo, ActiveThreadsInfo threadsInfo, Cache cache)
	{
		connection = connectionInfo;
		threads = threadsInfo;
		this.cache = cache;
	}
	
	/**
	 * Returns the connection Info information
	 * @return ConnectionInfo
	 */
	public ConnectionInfo    getConnectionInfo()    { return connection;  }
	
	/**
	 * Returns information about the active threads
	 * @return ActiveThreadsInfo
	 */
	public ActiveThreadsInfo getActiveThreadsInfo() { return threads;     }
	
	/**
	 * Returns LIVE's cache
	 * @return Cache 
	 */
	public Cache             getCache()             { return cache;       }
	
	/**
	 * Sets the cache to a new cache
	 * @param cache New cache
	 */
	public void              setCache(Cache cache)  { this.cache = cache; }
}
