/*
 * Created on Jul 15, 2005
 */
package live.threads;

import java.util.Iterator;

/**
 * This is a runner that runs each of the threads in the container in sequence.
 * This is used for tasks that are sequential, so that if a task fails all
 * subsequent tasks should be cancelled. If you want a container that will try
 * to run all tasks even if one fails but only lets one task be active at any
 * given time, use <tt>ParallelRunner</tt> with an parallelism of 1. See
 * (TODO) ParallelRunner's docs for specifics.
 * 
 * @author Evan Driscoll
 */
public class SequentialRunner extends Runner
{
	/**
	 * Creates a new sequential runner class
	 * @param initInfo Information needed to start the thread
	 * @param description Description of the thread
	 */
	public SequentialRunner(ThreadInitInfo initInfo, String description)
	{
		init(initInfo, description);
	}

	/**
	 * Starts the threads one at a time, cancels the rest of the threads if one fails
	 * @throws Exception
	 */
	protected void runImpl() throws Exception
	{
		Iterator iter = taskList.iterator();
		
		while(iter.hasNext())
		{
			ThreadedUserAction action = (ThreadedUserAction) iter.next();
			// for each(action that was scheduled to run)
			
			action.startJoinForever();
			
			//If the call failed
			if(action.rawResult() instanceof Exception || action.getStatus() != ThreadedUserAction.COMPLETE)
			{
				// Cancel the rest of the tasks
				while(iter.hasNext())
				{
					ThreadedUserAction toCancel = (ThreadedUserAction) iter.next();
					toCancel.setCanceled();
				}
				
				if(action.rawResult() instanceof Exception)
				{
					// Then throw the exception (ThreadedUserAction will deal with it
					// properly)
					setError((Exception) action.rawResult());
					throw (Exception)action.rawResult();
				}
			}
		}
	}
}
