/*
 * Created on Jul 21, 2005
 */
package live.threads;

import java.util.Iterator;

/**
 * This is an early version of the parallel runner. Currently it doesn't
 * support the parallelism parameter, but the constructor is there so that
 * client code needn't be changed later after support is added.
 * 
 * @author Evan Driscoll
 */
public class ParallelRunner extends Runner
{
	private static final int DEFAULT_PARALLELISM = 3;
	private static final int THREAD_CHECK_WAIT_MS = 500;
	private int thisThreadsParallelism;
	
	private final ActiveThreadsInfo active;
	
	private final ThreadInitInfo info; 
	
	/**
	 * Constructs a parallelRunner with a specified parallelism (number of threads to run at once)
	 * @param initInfo Thread initialization information
	 * @param description Description of the thread
	 * @param parallelism How many threads to run at once
	 */
	public ParallelRunner(ThreadInitInfo initInfo, String description, int parallelism)
	{
		init(initInfo, description, false);
		
		active = new ActiveThreadsInfo();
		info = new ThreadInitInfo(initInfo.getConnectionInfo(),
				active, initInfo.getCache());
		thisThreadsParallelism = parallelism;
		
	}
	
	/**
	 * Constructs a parallel runner with the default parallelism
	 * @param initInfo Initialization information for the thread
	 * @param description Description of the thread
	 */
	public ParallelRunner(ThreadInitInfo initInfo, String description)
	{
		this(initInfo, description, DEFAULT_PARALLELISM);
	}

	/**
	 * Starts the threads, up to thisThreadsParallelism of them at a time
	 * @throws Exception
	 */
	protected void runImpl() throws Exception
	{
		int i = 0;
		
		Iterator iter = taskList.iterator();
		while(iter.hasNext())
		{
			ThreadedUserAction action = (ThreadedUserAction) iter.next();
			// foreach(action that was scheduled to run)
			
			action.init(info);
		
			action.startNoJoin();
			
			sleep(50);
			
			int cIP = active.getInProgress().size();
			while(cIP >= thisThreadsParallelism)
			{
				sleep(500);
				cIP = active.getInProgress().size();
			}
		}
		
		iter = taskList.iterator();
		while(iter.hasNext())
		{
			ThreadedUserAction action = (ThreadedUserAction) iter.next();
			// foreach(action that was scheduled to run)
			
			if(!action.isFinished())
				action.join();
			
			//If the call failed
			if(action.getException() != null)
			{
				setError(action.getException());
			}
		}
	}
}
