/*
 * Created on Aug 9, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package live.struts.forms;

import live.constants.Misc;

/**
 * Handles validations for all LIVE
 * @author Evan Driscoll
 */
public class Validations
{
	protected static final boolean    ALLOW_UNGROUPED = true;
	protected static final boolean DISALLOW_UNGROUPED = false;
	
	/**
	 * Validates a group name, generates an error if the group name is not correct
	 * @param form The form you are using
	 * @param groupName Group name to validate
	 * @param allowUngrouped Whether (ungrouped) is a valid groupname
	 */
	protected static void validateGroupName(LiveForm form, String groupName, 
			boolean allowUngrouped)
	{
		if(groupName == null)
			form.addError("groupName.required");
		else if(!groupName.matches("[-\\w@#\\$\\+:]{1,32}"))
		{
			if( !(
					groupName.equalsIgnoreCase(live.dto.Group.UNGROUPED_NAME) 
					&& allowUngrouped
			   )  )
			form.addError("groupName.malformed");
		}
	}
	
	/**
	 * Validates a memory value and adds an error if it is incorrect.
	 * @param form Form you are using
	 * @param memory Memory value to check
	 * @param defOrMax Whether the memory value is for default or maximum memory
	 */
	protected static void validateMemory(LiveForm form, String memory, String defOrMax)
	{
		if(!memory.matches("[0-9]+[MG]"))
			form.addError(defOrMax + "Mem.malformed");
	}
	
	/**
	 * Validates a guest name, adds an error if it is incorrect
	 * @param form Form you are using
	 * @param guestName Guest name to validate
	 */
	protected static void validateGuestName(LiveForm form, String guestName)
	{
		if(!guestName.matches("[-a-zA-Z0-9@#$_]{1,8}"))
			form.addError("username.malformed");
	}
	
	/**
	 * Validates a password, adds an error if it is incorrect
	 * @param form Form you are using
	 * @param password Passwor to validate
	 */
	protected static void validatePassword(LiveForm form, String password)
	{
		if(!password.matches("[-a-zA-Z0-9@#$_]{1," + Misc.passLength + "}"))
			form.addError("password.malformed");
	}
	
	/**
	 * Ensures that the password and confirmation password match
	 * @param form Form you are using
	 * @param password Original password
	 * @param confirmation Confirmation password
	 */
	protected static void validatePasswordMatch(LiveForm form, String password, String confirmation)
	{
		if(! password.equalsIgnoreCase(confirmation))
			form.addError("password.confirmWrong");
	}
	
	/**
	 * Validates a string to make sure it can become an int
	 * @param form Form you are using
	 * @param parameter String that you want to convert to an int
	 * @param key Description of parameter, for error creation
	 */
	protected static void validateInt(LiveForm form, String parameter, String key)
	{
		try
		{
			int i = Integer.parseInt(parameter);
		}
		catch(NumberFormatException e)
		{
			form.addError(key);
		}
	}
	
	/**
	 * Validates a saved segment name, adds an error if it is incorrect
	 * @param form The form you are using
	 * @param segName The name of the segment you wish to validate
	 */
	protected static void validateSegmentName(LiveForm form, String segName)
	{
		if(!segName.matches("[-a-zA-Z0-9@#$_]{1,8}"))
			form.addError("segName.malformed");
	}
	
	/**
	 * Validates a network name, adds an error if it is incorrect
	 * @param form The form you are using
	 * @param netName The name of the network you wish to validate
	 */
	protected static void validateNetworkName(LiveForm form, String netName)
	{
		if(!netName.matches("[-a-zA-Z0-9@#$_]{1,8}"))
			form.addError("netName.malformed");
	}
	
	/**
	 * Validates a network's port, adds an error if it is incorrect
	 * @param form The form you are using
	 * @param portName The portname you wish to validate
	 */
	protected static void validateNetworkPort(LiveForm form, String portName)
	{
		final String onePort = "[-a-zA-Z0-9@#$_]{1,8}";
		final String onePortSpace = "(" +onePort + " )";
		
		if(!portName.matches(onePortSpace + "{0,2}" + onePort + "|"))
			form.addError("netPort.malformed");
	}
	
	/**
	 * Validates a network's real device address, adds an error if it is incorrect
	 * @param form The form you are using
	 * @param addr The real device address you wish to validate
	 */
	protected static void validateNetworkRAddr(LiveForm form, String addr)
	{
		if(! "".equals(addr))
			Validations.validateInt(form, addr, "netRAddress.malformed");
	}
}
