package live.struts.forms;

/**
 * The form for creating a new saved segment
 *
 * @author Evan Driscoll
 */
public class NewShMemForm extends LiveForm
{
	private String segSize="";
	private String segName = "";

	/**
	 * @param segName The segName to set.
	 */
	public void setSegName(String segName)
	{
		this.segName = segName;
		Validations.validateSegmentName(this, segName);
	}

	/**
	 * @return Returns the segName.
	 */
	public String getSegName()
	{
		return segName;
	}

	/**
	 * @param segSize The segSize to set.
	 */
	public void setSegSize(String segSize)
	{
		this.segSize = segSize;
		Validations.validateInt(this, segSize, "segSize.malformed");
	}

	/**
	 * @return Returns the segSize.
	 */
	public String getSegSize()
	{
		return segSize;
	}
}
