/*
 * NewNetworkForm.java
 * Created on June 20, 2005, 10:13 AM
 */
package live.struts.forms;

/**
 * Form to create a new network
 * @author Jason J. Herne
 */
public class NewNetworkForm extends LiveForm
{
    
    private String networkName;
    private String portname;
    private String address;
    
    /**
     * @return String new network name
     */
    public String getNetworkName()
    {
	return networkName;
    }
    
    /**
     * @return String returns the portname
     */
   public String getPortname()
    {
	return portname;
    }
    
   /**
    * @return String returns the real device address
    */
    public String getAddress()
    {
	return address;
    }
    
    /**
     * @param networkName network name to set
     */
    public void setNetworkName(String networkName)
    {
	this.networkName = networkName.toUpperCase();
	Validations.validateNetworkName(this, networkName);
    }
    
    /**
     * @param portname portname to set
     */
    public void setPortname(String portname)
    {
	this.portname = portname.toUpperCase();
	Validations.validateNetworkPort(this, portname);
    }
    
    /**
     * @param address real device address to set
     */
    public void setAddress(String address)
    {
	this.address = address;
	Validations.validateNetworkRAddr(this, address);
    }
}
