/*
 * Created on Aug 8, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package live.struts.forms;


/**
 * Form for creating a new guest
 * @author Evan Driscoll
 */
public class NewGuestForm extends ChMemoryForm
{
	private String userClass = "general",
		groupName = live.dto.Group.UNGROUPED_NAME,
		guestName = "",
		password = "";
	
	/**
	 * @param guestName Name of new guest
	 */
	public void setGuestName(String guestName)
	{
		this.guestName = guestName.toUpperCase();
		Validations.validateGuestName(this, guestName);
	}

	/**
	 * @return String name of new guest
	 */
	public String getGuestName()
	{
		return guestName;
	}

	/**
	 * @param password Password to set
	 */
	public void setPassword(String password)
	{
		this.password = password;
		Validations.validatePassword(this, password);
	}

	/**
	 * @return String new guest's password
	 */
	public String getPassword()
	{
		return password;
	}
	
	/**
	 * @param userClass The userClass to set.
	 */
	public void setUserClass(String userClass)
	{
		this.userClass = userClass;
	}

	/**
	 * @return Returns the userClass.
	 */
	public String getUserClass()
	{
		return userClass;
	}

	/**
	 * @param group The group to set.
	 */
	public void setGroupName(String group)
	{
		this.groupName = group;
		Validations.validateGroupName(this, group, Validations.ALLOW_UNGROUPED);
	}

	/**
	 * @return Returns the group.
	 */
	public String getGroupName()
	{
		return groupName;
	}
}
