/*
 * Created on Aug 8, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package live.struts.forms;

/**
 * The form for changing a guest's password
 */
public class GuestNamePassForm extends LiveForm
{
	private String guestName = "";
	private String password = null;
	private String confirm = null;
	
	/**
	 * @param userName Name of user to validate
	 */
	public void setGuestName(String userName)
	{
		this.guestName = userName;
		Validations.validateGuestName(this, userName);
	}

	/**
	 * @return Returns the guest's name
	 */
	public String getGuestName()
	{
		return guestName;
	}

	/**
	 * @param password Password to set
	 */
	public void setPassword(String password)
	{
		this.password = password;
		Validations.validatePassword(this, password);
		
		if(confirm != null)
			Validations.validatePasswordMatch(this, password, confirm);
	}

	/**
	 * @return Password of guest
	 */
	public String getPassword()
	{
		return password;
	}

	/**
	 * @param confirm The confirm to set.
	 */
	public void setConfirmPassword(String confirm)
	{
		this.confirm = confirm;
		
		if(password != null)
			Validations.validatePasswordMatch(this, password, confirm);
	}

	/**
	 * @return Returns the confirm.
	 */
	public String getConfirmPassword()
	{
		if(confirm != null)
			return confirm;
		else
			return "";
	}
}
