/*
 * Created on Aug 9, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package live.struts.forms;

/**
 * The form for cloning a guest
 * @author Evan Driscoll
 */
public class CloneForm extends LiveForm
{
	private String format = null;
	private String cloneDisks = "noclone";
	private String confirmPassword = null;
	private String password = "";
	private String startIdx= "1";
	private String numClones = "";
	private String multiple = null;
	private String cloneName ="";

	/**
	 * @param cloneName The cloneName to set.
	 */
	public void setCloneName(String cloneName)
	{
		this.cloneName = cloneName;
		Validations.validateGuestName(this, cloneName);
	}

	/**
	 * @return Returns the cloneName.
	 */
	public String getCloneName()
	{
		return cloneName;
	}

	/**
	 * @param multiple The multiple to set.
	 */
	public void setMultiple(String multiple)
	{
		this.multiple = multiple;
	}
	
	/**
	 * @return Whether to make multiple clones
	 */
	public boolean makeMultiple()
	{
		return (multiple != null);
	}

	/**
	 * @return Returns the multiple.
	 */
	public String getMultiple()
	{
		return multiple;
	}

	/**
	 * @param numClones The numClones to set.
	 */
	public void setNumClones(String numClones)
	{
		this.numClones = numClones;
		Validations.validateInt(this, numClones, "numClones.malformed");
	}

	/**
	 * @return Returns the numClones.
	 */
	public String getNumClones()
	{
		return numClones;
	}

	/**
	 * @param startIndex The startIndex to set.
	 */
	public void setStartIndex(String startIndex)
	{
		this.startIdx = startIndex;
		Validations.validateInt(this, numClones, "clonesStartIdx.malformed");
	}

	/**
	 * @return Returns the startIndex.
	 */
	public String getStartIndex()
	{
		return startIdx;
	}

	/**
	 * @param password The password to set.
	 */
	public void setPassword(String password)
	{
		System.out.println("Setting password");
		this.password = password;
		Validations.validatePassword(this, password);
		
		if(confirmPassword != null)
			Validations.validatePasswordMatch(this, password, confirmPassword);
	}

	/**
	 * @return Returns the password.
	 */
	public String getPassword()
	{
		return password;
	}

	/**
	 * @param confirmPassword The confirmPassword to set.
	 */
	public void setConfirmPassword(String confirmPassword)
	{
		System.out.println("Setting confirm password");
		this.confirmPassword = confirmPassword;
		
		if(password != null)
			Validations.validatePasswordMatch(this, getPassword(), confirmPassword);
	}

	/**
	 * @return Returns the confirmPassword.
	 */
	public String getConfirmPassword()
	{
		return confirmPassword;
	}

	/**
	 * @param cloneDisks The cloneDisks to set.
	 */
	public void setCloneDisks(String cloneDisks)
	{
		this.cloneDisks = cloneDisks;
	}

	/**
	 * @return Returns the cloneDisks.
	 */
	public String getCloneDisks()
	{
		return cloneDisks;
	}
	
	/**
	 * @return Whether to clone the guest's disks
	 */
	public boolean cloneDisks()
	{
		return (getCloneDisks().equals("clone"));
	}
	
	/**
	 * @param format The format to set.
	 */
	public void setFormat(String format)
	{
		this.format = format;
	}
	
	/**
	 * @return Returns the format.
	 */
	public String getFormat()
	{
		return format;
	}
	
	/**
	 * @return Whether to format the recreated disks
	 */
	public boolean format()
	{
		return (getFormat() != null);
	}
	
	/**
	 * @return int of how many clones to create
	 */
	public int numberClones()
	{
		return Integer.parseInt(getNumClones());
	}
	
	/**
	 * @return int of the starting number
	 */
	public int startIndex()
	{
		return Integer.parseInt(getStartIndex());
	}
}
