/*
 * Created on Aug 9, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package live.struts.forms;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;

/**
 * The form for changing a guest's memory
 * @author Evan Driscoll
 */
public class ChMemoryForm extends LiveForm
{
	private String defaultMem = "64M", 
		customDefMem = "", 
		customDefMemUnits = "MB",
		maximumMem = "128M", 
		customMaxMem = "", 
		customMaxMemUnits = "";
	
	/**
	 * Sets the units for max memory
	 *
	 * @param customMaxMemUnits The customMaxMemUnits to set.
	 */
	public void setCustomMaxMemUnits(String customMaxMemUnits)
	{
		this.customMaxMemUnits = customMaxMemUnits;
	}

	/**
	 * Returns the units for max memory
	 *
	 * @return Returns the customMaxMemUnits.
	 */
	public String getCustomMaxMemUnits()
	{
		return customMaxMemUnits;
	}

	/** 
	 * Sets the max memory to a custom value
	 *
	 * @param customMaxMem The customMaxMem to set.
	 */
	public void setCustomMaxMem(String customMaxMem)
	{
		this.customMaxMem = customMaxMem;
	}

	/**
	 * Returns the custom max memory
	 *
	 * @return the customMaxMem.
	 */
	public String getCustomMaxMem()
	{
		return customMaxMem;
	}

	/**
	 * Sets the max memory
	 *
	 * @param maximumMem The maximumMem to set.
	 */
	public void setMaximumMem(String maximumMem)
	{
		this.maximumMem = maximumMem;
	}

	/**
	 * Returns the maximum memory
	 *
	 * @return the maximumMem.
	 */
	public String getMaximumMem()
	{
		return maximumMem;
	}

	/**
	 * Sets the units for custom default memory
	 *
	 * @param customDefMemUnits The customDefMemUnits to set.
	 */
	public void setCustomDefMemUnits(String customDefMemUnits)
	{
		this.customDefMemUnits = customDefMemUnits;
	}

	/**
	 * Returns the units for custom default memory
	 *
	 * @return the customDefMemUnits.
	 */
	public String getCustomDefMemUnits()
	{
		return customDefMemUnits;
	}

	/**
	 * Sets the custom default memory
	 *
	 * @param customDefMem The customDefMem to set.
	 */
	public void setCustomDefMem(String customDefMem)
	{
		this.customDefMem = customDefMem;
	}

	/**
	 * Returns the custom default memory
	 *
	 * @return Returns the customDefMem.
	 */
	public String getCustomDefMem()
	{
		return customDefMem;
	}

	/**
	 * Sets the default memory
	 *
	 * @param defaultMem The defaultMem to set.
	 */
	public void setDefaultMem(String defaultMem)
	{
		this.defaultMem = defaultMem;
	}

	/**
	 * Returns the default memory 
	 * @return the defaultMem.
	 */
	public String getDefaultMem()
	{
		return defaultMem;
	}
	
	/**
	 * Returns the default memory and its units
	 * @return the default memory and its units
	 */
	public String getDefaultMemory()
	{
		if( "custom".equals(getDefaultMem()) )
			return getCustomDefMem() + getCustomDefMemUnits();
		else
			return getDefaultMem();
	}
	
	/**
	 * @return Returns the maximum memory and its units
	 */
	public String getMaximumMemory()
	{
		if( "custom".equals(getMaximumMem()) )
			return getCustomMaxMem() + getCustomMaxMemUnits();
		else
			return getMaximumMem();
	}
	
	/**
	 * @see live.struts.forms.LiveForm#validate(ActionMapping, HttpServletRequest)
	 */
	public ActionErrors validate(ActionMapping m, HttpServletRequest r)
	{
		Validations.validateMemory(this, getDefaultMemory(), "default");
		Validations.validateMemory(this, getMaximumMemory(), "maximum");
		
		return super.validate(m, r);
	}
}
