/*
 * LoginAction.java Created on June 6, 2005, 8:34 AM
 */
package live.struts.actions;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionForward;

import live.threads.ThreadInitInfo;
import live.constants.Attributes;
/**
 * Various important functions and constants for actions
 */
public class Util
{
	/** Utility constants */
	private static final int SECONDS = 1000;
	
	/** Holds the timeout before actions return to a timeout page */
	public static final int TIMEOUT_MS = 10 * SECONDS;
	
	/**
	 * This function builds the URL+query string that was used to get the
	 * current page. It does this by concatinating the URL of the current
	 * request with "?" and the query string if the latter is present.
	 * 
	 * @param request The request BuildRequestString should build the URL of
	 * @return The URL that was used to load the page with the request passed
	 *         in.
	 */
	public static String buildRequestString(HttpServletRequest request)
	{
		StringBuffer sb = new StringBuffer();
		sb.append(request.getRequestURL());
		if(request.getQueryString() != null
				&& !request.getQueryString().equals(""))
			sb.append("?").append(request.getQueryString());

		return sb.toString();
	}


	/**
	 * This function checks to see if there are any threads that have recently
	 * completed and, if so, adds the list to the request attribute
	 * recentlyCompleteThreads.
	 * 
	 * @param request The request for the current page
	 */
	public static void checkForDoneActions(HttpServletRequest request)
	{
		HttpSession session = request.getSession(true);

		ThreadInitInfo threadInfo = (ThreadInitInfo)session
				.getAttribute(Attributes.session.threadInfo);

		if(threadInfo == null)
			return;

		LinkedList complete = threadInfo.getActiveThreadsInfo()
				.getRecentlyComplete();

		if(complete.size() > 0)
			request.setAttribute(Attributes.Global.recentlyCompleteThreads,
					complete);
	}

	
	/**
	 * Returns a Set of guest names (Strings) that are checked by the user.
	 * Specifically, it returns a list of all parameter names (not values)
	 * that begin with "GUEST_".  
	 * 
	 * @param request The servlet request (where the parameter list is from)
	 * @return A Set of guest names selected by the user
	 */
	static HashSet getUserSelectedGuestNames(HttpServletRequest request)
	{
		HashSet guests = new HashSet();

		Iterator iter = request.getParameterMap().entrySet().iterator();
		while(iter.hasNext())
		{
			Map.Entry entry = (Map.Entry)iter.next();
			// foreach(entry in the request parameter map),
			// get the guest name
			String param = (String)entry.getKey();

			// TODO: replace GUEST_ and 6 with constants 
			if(param.startsWith("GUEST_")
					&& request.getParameter(param).equals("on"))
			{
				// chop off the GUEST_
				String guestName = param.substring(6);
				
				guests.add(guestName);
			}
		}

		return guests;
	}
	
	protected static void setRedirectAndParams(
			org.apache.struts.action.ActionForward forward,
			HttpServletRequest request)
	{
		if(forward!=null && forward.getPath()!=null)
		{
			// This is our heuristic for determining if we redirect or forward.
			// If we go to a JSP, we forward; if we go to another action, we
			// redirect.
			if(forward.getPath().indexOf(".page") != -1 || 
			   forward.getPath().indexOf(".do") != -1)
			{
				// we can't modify the original
				forward = new ActionForward(forward);
				
				String fwdURL = forward.getPath() + queryString(request);
				
				forward.setPath(fwdURL);
				forward.setRedirect(true);
			}
		}
	}
	
	private static String queryString(HttpServletRequest request)
	{
		Map map = request.getParameterMap();
		
		if(map.size() == 0)
			return "";
		
		StringBuffer ret = new StringBuffer();
		
		ret.append("?");
		
		Iterator iter=map.entrySet().iterator();
		while(iter.hasNext())
		{
			Map.Entry entry = (Map.Entry) iter.next();
			String name = (String) entry.getKey();
			String[] values = (String[]) entry.getValue();
			// foreach(<name, values> in map)
			
			for(int i=0 ; i<values.length ; ++i)
			{
				ret.append(name).append("=").append(values[i]).append("&");
			}
		}
		
		// Cut out the last & we put on the end
		ret.deleteCharAt( ret.length() - 1);
		
		return ret.toString();
	}
}
