/*
 * Created on Jun 30, 2005
 */
package live.struts.actions;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import java.util.Collections;

import org.apache.struts.action.ActionForward;

import live.threads.ActiveThreadsInfo;
import live.threads.Runner;
import live.threads.ThreadedUserAction;
import live.dto.Thread;
import live.constants.Mappings;
import live.constants.Attributes;

/**
 * Action  to display the status page
 * 
 * @author Evan Driscoll
 */
public class ShowStatusAction extends DisplayAction
{
	/**
	 * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward displayPage(CheckedAction.ActionInfo info)
	{
		String tid1 = info.getRequestParameter("tid");
		String tid2 = (String) info.getRequestAttribute("tid");
		
		String tid;
		
		if(tid1 != null)
			tid = tid1;
		else if(tid2 != null)
			tid = tid2;
		else
			tid = null;
		
		if(tid == null)
			return executeGeneralStatus(info);
		else
			return executeSpecificStatus(info, Integer.parseInt(tid));
	}
	
	
	/**
	 * Brings up the page with the list of all tasks and their statuses.
	 * @param info ActionInfo with information on tasks and how they should be sorted
	 * @return ActionForward maps to page with all the tasks and their ordering
	 */
	public ActionForward executeGeneralStatus(CheckedAction.ActionInfo info)
	{
		ActiveThreadsInfo threadInfo = info.threadInfo.getActiveThreadsInfo();
		
		LinkedList inProgress = threadInfo.getInProgress();
		LinkedList completed  = threadInfo.getCompletedJobs();
		
		Vector threads = new Vector();
		
		synchronized(inProgress)
		{
			synchronized(completed)
			{
				Iterator iter = inProgress.iterator();
				while(iter.hasNext())
				{
					ThreadedUserAction action = (ThreadedUserAction) iter.next();
					threads.add(new Thread(action));
				}
				
				iter = completed.iterator();
				while(iter.hasNext())
				{
					ThreadedUserAction action = (ThreadedUserAction) iter.next();
					threads.add(new Thread(action));
				}
			}
		}
		
		Object o = info.getRequestParameter("reverse");
		boolean reverse;
		if(o == null)
			reverse = true;
		else
			reverse = false;
		
		Thread.ThreadComparator compare;
		String sortby = info.getRequestParameter("sortby");
		if(sortby == null || sortby.equals("started"))
		{
			compare = new Thread.ComparatorByTimeStarted();
		}
		else if(sortby.equals("ended"))
		{
			compare = new Thread.ComparatorByTimeEnded();
		}
		else if(sortby.equals("description"))
		{
			compare = new Thread.ComparatorByDescription();
		}
		else if(sortby.equals("result"))
		{
			compare = new Thread.ComparatorByResult();
		}
		else
		{
			compare = new Thread.ComparatorByTimeStarted();
		}
		
		Collections.sort(threads, compare.setReverse(reverse));
				
		info.setRequestAttribute(Attributes.status.general.threadList, threads);
		
		if(sortby != null)
		{
			if(!reverse)
			{
				info.setRequestAttribute(sortby, sortby);
			}
			else
			{
				info.setRequestAttribute("started", "started");
				info.setRequestAttribute("ended", "ended");
				info.setRequestAttribute("description", "description");
				info.setRequestAttribute("result", "result");
				
				info.setRequestAttribute(sortby, null);
			}
		}
		else
		{
			info.setRequestAttribute("started", "started");
		}
		
		return info.findForward(Mappings.status.General);
	}
	
	
	/**
	 * Brings up a page wtih information on a specific task.
	 *
	 * @param info Information needed to complete the action, including job status.
	 * @param tid ID of the task that you want to bring up the status of.
	 * @return ActionForward Page with the task's status.
	 */
	public ActionForward executeSpecificStatus(CheckedAction.ActionInfo info, int tid)
	{
		ActiveThreadsInfo threadInfo = info.threadInfo.getActiveThreadsInfo();
		
		LinkedList inProgress = threadInfo.getInProgress();
		LinkedList completed  = threadInfo.getCompletedJobs();
		
		//Vector threads = new Vector();
		
		ThreadedUserAction action = null;
		
		synchronized(inProgress)
		{
			synchronized(completed)
			{
				Iterator iter = inProgress.iterator();
				while(iter.hasNext() && action==null)
				{
					ThreadedUserAction candidate = (ThreadedUserAction) iter.next();
					if(tid == candidate.getID())
						action = candidate;
				}
				
				iter = completed.iterator();
				while(iter.hasNext() && action==null)
				{
					ThreadedUserAction candidate = (ThreadedUserAction) iter.next();
					if(tid == candidate.getID())
						action = candidate;
				}
			}
		}
		
		if(action == null)
		{
			System.out.println("Failed to find thread with ID " + tid);
			info.setRequestAttribute(Attributes.error.message, "Thread ID not found");
			return info.findForward(Mappings.status.bad);
		}
		
		if(action instanceof Runner)
		{
			info.setRequestAttribute("runner", action);
		}

		return info.findForward(Mappings.status.Specific);
	}
}
