package live.struts.actions;

import org.apache.struts.action.ActionForward;

import live.threads.ThreadedZVMTasks;
import live.constants.Mappings;

/**
 * Displays information about a saved segment, as specified by the request parameter segName
 */
public class SharedMemInfoAction extends DisplayAction
{
    /**
     * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
     */
    public ActionForward displayPage(CheckedAction.ActionInfo info)
    {   
	String segName = info.request.getParameter("segName");
	info.request.setAttribute("segName", segName);
	
	//Get list of guests have access to this segment
	ThreadedZVMTasks.SharedStorageAccessQueryNameList  accessThread =
		new ThreadedZVMTasks.SharedStorageAccessQueryNameList(info.threadInfo, segName);
	
	accessThread.startJoinForever();
	
	//Now that the query is done, go to errorpage if we had an error, or the info page
	//if we didnt have an error.  Oh, and dont forget to pass along the guest list to
	//the info page.
	if(accessThread.rawResult() instanceof Exception)
	{
	    info.request.setAttribute("errorMessage", (accessThread.getException()).getMessage());
	    return info.findForward(Mappings.sharedSegments.info.error);
	}
	
	//If we get here, there was no error.
	
	info.request.setAttribute("guests", accessThread.rawResult());
	return info.findForward(Mappings.sharedSegments.info.OK);
	
	
    }
}