/*
 * NewNetworkAction.java Created on June 20, 2005, 10:12 AM
 */
package live.struts.actions;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Iterator;

import org.apache.struts.action.ActionForward;

import live.threads.SequentialRunner;
import live.threads.ParallelRunner;
import live.threads.ThreadedZVMTasks;
import live.constants.Mappings;
import live.constants.Attributes;

/**
 * Action to create a new saved memory segment
 * 
 * @author Jason J. Herne
 * @author Evan Driscoll
 */
public class NewSharedMemAction extends SwitchedAction
{
    /**
    * @see live.struts.actions.SwitchedAction#performAction(live.struts.actions.CheckedAction.ActionInfo)
    */
    public ActionForward performAction(CheckedAction.ActionInfo info)
    {
	//Grab values from form that are needed to create the segment.
	String segName = info.request.getParameter("segName");
	String segSize = info.request.getParameter("segSize");
	HashSet selectedGuests = Util.getUserSelectedGuestNames(info.request);
	
	//Copy elements from HashSet to LinkedList
	LinkedList selectedGuestsList = new LinkedList();
	Iterator itr = selectedGuests.iterator();
	while(itr.hasNext())
	{
	    selectedGuestsList.add(itr.next());
	}
	
	//Create thread for creating shares segment.
	ThreadedZVMTasks.SharedStorageCreate thread = new ThreadedZVMTasks.SharedStorageCreate(info.threadInfo, segName, segSize, selectedGuestsList);
	
	//Paraller runner for the access list tasks
	ParallelRunner accessRunner = new ParallelRunner(info.threadInfo, "Creating shared storage access records");
	
	itr = selectedGuests.iterator();
	while(itr.hasNext())
	{
	    //Create threads for giving all selected guests access to segment
	    accessRunner.schedule( new ThreadedZVMTasks.SharedStorageAccessAdd(info.threadInfo, (String)itr.next(), segName ));
	}

	//Sequential runner for the create thread and the parallel runner
	SequentialRunner mainRunner = new SequentialRunner(info.threadInfo, "Creating Shared Storage");
	mainRunner.schedule(thread);
	mainRunner.schedule(accessRunner);
	mainRunner.startJoinTimeout(Util.TIMEOUT_MS);
	
	return info.smartForward(mainRunner, Mappings.sharedSegments.list.OK);
    }

    /**
    * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
    */
    public ActionForward displayPage(CheckedAction.ActionInfo info)
    {
	// Now we give it the list of all guests
	info.setRequestAttribute(Attributes.sharedSegmentsNew.groups , info.cache.getGroups());

	return info.findForward(Mappings.sharedSegments.newseg.OK);
    }
}

