/*
 * NewNetworkAction.java Created on June 20, 2005, 10:12 AM
 */
package live.struts.actions;

import java.util.HashSet;

import org.apache.struts.action.ActionForward;

import live.struts.forms.NewNetworkForm;

import live.threads.Runner;
import live.threads.SequentialRunner;
import live.threads.ParallelRunner;
import live.threads.ThreadedZVMTasks;

import live.dto.Network;
import live.constants.Mappings;
import live.constants.Attributes;

/**
 * Action to create a new network
 *
 * @author Jason J. Herne
 * @author Evan Driscoll
 */
public class NewNetworkAction extends SwitchedAction
{
	/**
	 * @see live.struts.actions.SwitchedAction#performAction(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward performAction(CheckedAction.ActionInfo info)
	{
		//Grab values from form that are needed to create network.
		NewNetworkForm frm = ((NewNetworkForm)info.form);
		String lanName = frm.getNetworkName();
		String rdev = frm.getAddress();
		String portname = frm.getPortname();

		// We only support VSwitches at this time
		int netTypeInt = Network.NETWORK_VSWITCH;

		// Figure out who the user selected
		HashSet usernamesToConnect = Util.getUserSelectedGuestNames(info.request);

		// The way we do this is sorta curious. We have to create the network
		// before adding anyone to it, so we use a sequential runner at the
		// highest level. However, all the additions can be done in parallel,
		// so we don't want to unnecessarily serialize it. So we put all the
		// additions into a parallel runner, then put the parallel
		// runner into a sequential runner with the create action. 
		SequentialRunner mainThread = new 
			SequentialRunner(info.threadInfo, "Creating network " + lanName);
		
		ThreadedZVMTasks.CreateVSwitch create = new 
			ThreadedZVMTasks.CreateVSwitch(
				info.threadInfo, lanName, portname, rdev);
		mainThread.schedule(create);

		
		ThreadedZVMTasks.FindCommonFreeAddress addy =
			new ThreadedZVMTasks.FindCommonFreeAddress(info.threadInfo, null);
		mainThread.schedule(addy);
		
		Runner addThread = new 
		ParallelRunner(info.threadInfo, "Adding members to " + lanName);
		
		// Here's where we schedule all the additions
		tellThreadAboutConnections(usernamesToConnect, info, addThread, lanName, addy);
		
		
		mainThread.schedule(addThread);
		
		mainThread.startJoinTimeout(Util.TIMEOUT_MS);

		return info.smartForward(mainThread, Mappings.networks.list.This);
	}
	
	/**
	 * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward displayPage(CheckedAction.ActionInfo info)
    {
		//System.out.println("In New Network Display Page");
		info.setRequestAttribute(Attributes.networks.newPage.groupList, 
				info.cache.getGroups());
		return info.findForward(Mappings.networks.newPage.DisplayPage);
   }
	
	//// HELPER FUNCTIONS
	private void tellThreadAboutConnections(HashSet usernames, 
			CheckedAction.ActionInfo info, Runner runner,
			String netName,
			ThreadedZVMTasks.FindCommonFreeAddress addySource)
	{
		java.util.Iterator iter = usernames.iterator();
		while(iter.hasNext())
		{
			String guestName = (String) iter.next();
			// foreach(guestName we have to add to the network)
			
			// We get the address they are connecting with
			String vAddress = info.getRequestParameter("ADDRESS_" + guestName);
			
			// Then schedule it.
			ThreadedZVMTasks.VSwitchCreateConnect a;
			
			// [0-9a-fA-F]{1,4} <- regular expression
			if(vAddress!=null && !vAddress.equals(""))
			{
				a = new ThreadedZVMTasks.VSwitchCreateConnect(
						info.threadInfo, netName, null, null, guestName, vAddress);
			}
			else
			{
				addySource.addSource(guestName);
				a = new ThreadedZVMTasks.VSwitchCreateConnect(
						info.threadInfo, netName, null, null, guestName, addySource);
			}

			runner.schedule(a);
		}
	}
}
