/*
 * Created on Jul 12, 2005
 */
package live.struts.actions;

import org.apache.struts.action.ActionForward;

import live.struts.forms.NewGuestForm;

import live.dto.Group;
import live.threads.SequentialRunner;
import live.threads.ThreadedZVMTasks;
import live.constants.Mappings;
import live.constants.Attributes;


/**
 * Creates a new guest
 * 
 * @author Evan Driscoll
 */
public class NewGuestAction extends SwitchedAction
{

	/**
	 * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward performAction(ActionInfo info)
	{
		NewGuestForm form = (NewGuestForm) info.form;
		
		String name        = form.getGuestName();
		String password    = form.getPassword();
		String initMem     = form.getDefaultMemory();
		String maxMem      = form.getMaximumMemory();
		String profileName = form.getUserClass();
		String newGroup    = form.getGroupName();
		
		// Now that we've figured out what we want to do, let's do it
		
		SequentialRunner mainThread = new SequentialRunner(info.threadInfo,
				"Creating guest " + name);
		
		ThreadedZVMTasks.CreateGuest create = 
			new ThreadedZVMTasks.CreateGuest(info.threadInfo, name, password, 
					initMem, maxMem, profileName);
		
		boolean done; // no assignment so compiler will do some checking for us
		
		if(! Group.UNGROUPED_NAME.equalsIgnoreCase(newGroup) )
		{
			ThreadedZVMTasks.SetGuestToGroup setGroup =
				new ThreadedZVMTasks.SetGuestToGroup(info.threadInfo, 
						name, null, newGroup);
			
			mainThread.schedule(create);
			mainThread.schedule(setGroup);
			
			done = mainThread.startJoinTimeout(10 * 1000);
		}
		else
		{
			done = create.startJoinTimeout(Util.TIMEOUT_MS);
		}
		
		return info.smartForward(mainThread, Mappings.guests.list.This);
	}

	/**
	 * @see live.struts.actions.SwitchedAction#performAction(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward displayPage(ActionInfo info)
	{
		info.setRequestAttribute(Attributes.guests.newGuest.groupList,
				info.cache.getGroupNames());
		
		return info.findForward(Mappings.guests.newGuest.showForm);
	}

}
