/*
 * Created on Jul 7, 2005
 */
package live.struts.actions;

import java.util.Iterator;
import java.util.Set;
import java.util.HashSet;

import org.apache.struts.action.ActionForward;

import live.constants.Attributes;
import live.constants.Mappings;
import live.threads.ThreadedUserAction;
import live.threads.ThreadedZVMTasks;
import live.threads.ParallelRunner;
import live.threads.Runner;
import live.struts.forms.NewGroupForm;

/**
 * This action both creates a new group and -- here's the tricky part -- changes
 * the membership of a group. (This is if you change the membership of a group, not
 * change what group a particular image is in.)
 * 
 * @author Evan Driscoll
 */
public class NewGroupAction extends SwitchedAction
{
	/**
	 * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward displayPage(CheckedAction.ActionInfo info)
	{
		info.setRequestAttribute(Attributes.guests.newGroup.groupList,
				info.cache.getGroups());

		// We get the group from the cache, if it's there. (Remember, this
		// is also for changing membership.) If it's not there, it's no big
		// deal, because getGuestsInGroup doesn't throw if it's not there,
		// just returns an empty string.
		String groupName = info.getRequestParameter("groupName");
		
		// Those guests that are currently in the group are checked by default.
		// For the same reason we use a Set for active images we use a Set here;
		// it reduces the time to display the list from potentially O(n*n) to O(n)
		HashSet set = new HashSet( info.cache.getGuestNamesInGroup(groupName) );

		info.setRequestAttribute(Attributes.guests.newGroup.checkByDefault_OPT,
				set);
		
		info.setRequestAttribute("groupName", info.getRequestParameter("groupName"));

		return info.findForward(Mappings.guests.newGroup.showForm);
	}

	/**
	 * @see live.struts.actions.SwitchedAction#performAction(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward performAction(CheckedAction.ActionInfo info)
	{
		NewGroupForm form = (NewGroupForm) info.form;
		
		String groupName = form.getGroupName();
		

		// shouldBeInGroup is the collection of those guests that
		// the user checked
		HashSet shouldBeInGroup = Util.getUserSelectedGuestNames(info.request);
		
		HashSet currentlyInGroup = 
			new HashSet(info.cache.getGuestNamesInGroup(groupName));

		// Images we want to add are ones that should be in the group
		// but are not currently. removeAll acts like (is) set difference;
		// after a.removeAll(b), a = a_0 - b. (a_0 was a before the statement.)
		Set imagesToAdd = (Set)shouldBeInGroup.clone();
		imagesToAdd.removeAll(currentlyInGroup);

		// Images we want to remove are ones that are in the group
		// but shouldn't be
		Set imagesToRemove = (Set)currentlyInGroup.clone();
		imagesToRemove.removeAll(shouldBeInGroup);

		// TODO: factor out those loops into a separate function
		
		Runner mainThread = new ParallelRunner(info.threadInfo,
				"Add guests to " + groupName);

		// For each guest we need to add...
		Iterator iter = imagesToAdd.iterator();
		while(iter.hasNext())
		{
			String guestName = (String)iter.next();
			
			String currentGroup = info.cache.getGuest(guestName).getGroupName();
			
			// ... move them into the current group.
			ThreadedUserAction thisGuest = new ThreadedZVMTasks.SetGuestToGroup(
					info.threadInfo, guestName, currentGroup, groupName);
			mainThread.schedule(thisGuest);
		}

		// For each guest we need to remove...
		iter = imagesToRemove.iterator();
		while(iter.hasNext())
		{
			String guestName = (String)iter.next();
			
			// ...move them into ungrouped.
			String currentGroup = info.cache.getGuest(guestName).getGroupName();
			ThreadedUserAction thisGuest = new ThreadedZVMTasks.SetGuestToGroup(
					info.threadInfo, guestName, currentGroup, null);
			mainThread.schedule(thisGuest);
		}

		mainThread.startJoinTimeout(Util.TIMEOUT_MS);

		return info.smartForward(mainThread, Mappings.guests.list.This);
		
		/*if(mainThread.isFinished())
			return Mappings.guests.list.This;
		else
			return Mappings.guests.newGroup.timeout;*/
	}
}
