/*
 * LoginAction.java
 * Created on June 6, 2005, 8:34 AM
 */
package live.struts.actions;

import org.apache.struts.action.ActionForward;

import live.dto.Network;
import live.constants.Mappings;
import live.constants.Attributes;
import live.threads.ThreadedZVMTasks;

/**
 * Action to display information about a network, as specified in the request parameter netName
 * @author Jason J. Herne
 */
public class NetworkInfoAction extends DisplayAction
{
 
    /**
     * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
     */
    public ActionForward displayPage(CheckedAction.ActionInfo info)
    {
		String netName = info.getRequestParameter("netName");
		info.setRequestAttribute(Attributes.networks.info.name, netName);
		
		// Go to the server to get the members...
		ThreadedZVMTasks.QueryNetworkMembers thread = new ThreadedZVMTasks.QueryNetworkMembers(info.threadInfo, netName);
		thread.startJoinForever();
		
		// ...and pass them to the JSP.
		info.setRequestAttribute(Attributes.networks.info.members, ((Network) thread.rawResult()).getMembers());
		
		return info.findForward(Mappings.networks.info.OK);
    }
    
}
