/*
 * LoginAction.java
 * Created on June 6, 2005, 8:34 AM
 */
package live.struts.actions;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.Globals;
import org.apache.struts.action.*;

import live.struts.forms.GuestNamePassForm;
import live.threads.ThreadInitInfo;
import live.dto.ConnectionInfo;
import live.threads.ActiveThreadsInfo;
import live.threads.ThreadedZVMTasks;
import live.constants.Properties;
import live.constants.Mappings;
import live.constants.Attributes;

/**
 * This is the action to log a user into LIVE
 * @author Jason J. Herne
 */
public class LoginAction extends Action
{
    /**
     * @see org.apache.struts.action.Action#execute(org.apache.struts.action.ActionMapping,
     *      org.apache.struts.action.ActionForm,
     *      javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form,
				HttpServletRequest request, HttpServletResponse response)
	throws java.lang.InterruptedException
    {
        GuestNamePassForm f = (GuestNamePassForm)form;
        
        System.out.println(f.getGuestName() + ": " + f.getPassword());
	
	/* clear any possible previous session information*/
	//HttpSession session = request.getSession(false);
	//session.
	
	// Setup a new session for this user.
	//HttpSession session = request.getSession(false);
        
        HttpSession session = request.getSession();
	
	//Get host and port from configuration file.
	String hostName = getResources(request).getMessage(Properties.live.host);
	//System.out.println(hostName);
	//System.out.println(getResources(request).getMessage(Properties.live.port));
	int port = Integer.parseInt(getResources(request).getMessage(Properties.live.port));
	
	ConnectionInfo conInfo = new ConnectionInfo(hostName, port, f.getGuestName(), f.getPassword());
	ActiveThreadsInfo actThreadInfo = new ActiveThreadsInfo();
	ThreadInitInfo threadInfo = new ThreadInitInfo(conInfo, actThreadInfo, null);
	
	
	//Authenticate
	ThreadedZVMTasks.Authenticate authThread = new ThreadedZVMTasks.Authenticate(threadInfo);
	authThread.start();

	authThread.join();
	
	Object result = authThread.rawResult();
	
	if((result instanceof Boolean))
	{ 
		// The call "succeeded" (there was no weird error; either the authentication
		// worked or we got a invalid credentials error)
		
	    if ( !((Boolean)result).booleanValue() )
	    {
	    	// Authentication BAD
			ActionErrors errors = new ActionErrors();
			errors.add(ActionErrors.GLOBAL_MESSAGE, 
					new ActionMessage("errors.authentication.failed"));
			request.setAttribute(Globals.ERROR_KEY, errors);
			return mapping.getInputForward();
	    }

	    session.setAttribute(Attributes.session.threadInfo, threadInfo);
		
	    // This is the normal path
	    // We test if we should be going somewhere other than the main page
	    // (i.e. we're reauthenticating)
	    Object forward = session.getAttribute(Attributes.login.forwardTo_OPT);
	    
	    if(forward != null)
	    	System.out.print("On login, forwardto attribute is [" + forward + "]");
	    else
	    	System.out.print("On login, forwardto attribute is null");
	    
		if(forward == null || !(forward instanceof String))
		{
			System.out.println(" which is nothing special. Going to normal forward.");
			ActionForward af = 
				new ActionForward(mapping.findForward(Mappings.guests.list.This));
			af.setRedirect(true);
			return af;
		}
		else
		{
			System.out.println(" which is special. Going there.");
			ActionForward af = new ActionForward((String) forward);
			af.setRedirect(true);
			return af;
		}
	}
	else if(result != null && result instanceof Throwable)
	{
		//If we get here, result is an exception!
		request.setAttribute(Attributes.error.message, ((Throwable)result).getMessage());
		return mapping.findForward(Mappings.login.error);
	}
	
	// shouldn't happen, but this makes the compiler happy
	request.setAttribute(Attributes.error.message, "Something is totally borked. (The authentication thread returned neither a Boolean nor an Exception)");
	return mapping.findForward(Mappings.login.error);
    }
    
}
