/*
 * SharedStorageQueryAction.java
 * Created on July 28, 2005, 1:57 PM
 */
package live.struts.actions;

import live.threads.ThreadedZVMTasks;
import java.util.LinkedList;

import org.apache.struts.action.ActionForward;

import live.constants.Mappings;
import live.constants.Attributes;

/**
 * Action that lists all the saved segments in the cache for the Shared Memory main page
 */
public class ListSharedMemAction extends DisplayAction
{
    /**
     * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
     */
    public ActionForward displayPage(CheckedAction.ActionInfo info)
    {
	//Perform the query
	ThreadedZVMTasks.QuerySharedStorage thread = 
		new ThreadedZVMTasks.QuerySharedStorage(info.threadInfo);
	thread.start();

	// Need to wait for our threads to finish up their tasks, otherwise
	// we won't have anything to display
	thread.startJoinForever();

	if(thread.rawResult() instanceof LinkedList)
	{
	    
	    // This is the non-error case
	    LinkedList segsList = (LinkedList) thread.rawResult();
	    info.setRequestAttribute(Attributes.sharedSegmentsList.segments, segsList);
	    
	    return info.findForward(Mappings.sharedSegments.list.OK);
	}
	else
	{
	    // Stuff broke
	    if(thread.rawResult() instanceof Exception)
	    {
		// The error was with the image query
		info.setRequestAttribute(Attributes.error.message, thread.rawResult());
	    }

	    return info.findForward(Mappings.guests.info.error);
	}
    }
}
