/*
 * LoginAction.java
 * Created on June 6, 2005, 8:34 AM
 */
package live.struts.actions;

import java.util.LinkedList;
import java.util.ListIterator;

import org.apache.struts.action.ActionForward;

import live.dto.Network;
import live.constants.Mappings;
import live.constants.Attributes;

/**
 * Action to get the list of networks for the networks main page
 * @author Jason J. Herne
 */
public class ListNetworksAction extends DisplayAction
{
    /**
     * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
     */
    public ActionForward displayPage(CheckedAction.ActionInfo info)
    {
    	// This just goes into the cache and produces a linked list of 
    	// VSwitches and of Guest LANs and passes them to the JSP.
		LinkedList glans = new LinkedList();
		LinkedList vswitches = new LinkedList();
		
		for(ListIterator iter = info.cache.getNetworks() ; iter.hasNext() ; )
		{
			Network net = (Network) iter.next();
			
			switch(net.getNetworkType())
			{
				case Network.NETWORK_GLAN:
					// This really sholudn't happen because we don't deal with it
					glans.add(net);
					break;
				case Network.NETWORK_VSWITCH:
					vswitches.add(net);
					break;
				default:
					throw new RuntimeException("Unreachable code reached");
			}
		}
			
		info.setRequestAttribute(Attributes.networks.list.vswitches, vswitches);
		//info.setRequestAttribute(Attributes.networks.list.glans, glans);
		
		return info.findForward(Mappings.networks.list.OK);
    }
}
