/*
 * LoginAction.java Created on June 6, 2005, 8:34 AM
 */
package live.struts.actions;

import java.util.Set;
import java.util.HashSet;
import java.util.Collection;

import org.apache.struts.action.ActionForward;

import live.threads.ThreadedUserAction;
import live.threads.ThreadedZVMTasks;
import live.constants.Mappings;
import live.constants.Attributes;

/**
 * Action that lists all the guests and whether they are active or not.
 *   Used on the guests/groups page
 */
public class ListGuestsAction extends DisplayAction
{

	/**
	 * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward displayPage(CheckedAction.ActionInfo info)
	{
		// Setup a new session for this user.
		ThreadedUserAction thread = 
			new ThreadedZVMTasks.ActiveImagesQuery(info.threadInfo);
		// Set a timeout, but here we just die and the user doesn't
		// see active images. (It's not essential that they see it.)
		thread.startJoinTimeout(10 * 1000);

		if(thread.rawResult() != null
				&& thread.rawResult() instanceof Collection)
		{
			// If the call succeeded, then we store it for the JSP to use.
			// BTW, we use a HashSet instead of returning the LinkedList
			// because when the JSP prints the list of guests, for every
			// guest -- inactive or not -- it checks if it's present in this
			// set. With no gurantees on order, this means that if there are
			// n images and m are active, this takes on the order of O(n*m).
			// This means that it'd be more or less quadratic. With a set,
			// the present check is (I think) constant time, which means O(n).
			// (At the most it's log m meaning O(n log m).)
			Set active = new HashSet((Collection)thread.rawResult());
			info.setRequestAttribute(Attributes.guests.list.active_set_OPT,
					active);
		}

		// Now we give it the list of all guests
		info.setRequestAttribute(Attributes.guests.list.groups, 
				info.cache.getGroups());


		return info.findForward(Mappings.guests.list.OK);
	}

}
