/*
 * LoginAction.java
 * Created on June 6, 2005, 8:34 AM
 */
package live.struts.actions;
import live.dto.Guest;
import live.dto.Group;
import live.threads.ThreadedZVMTasks;

import java.util.LinkedList;

import org.apache.struts.action.ActionForward;

import live.constants.Mappings;
import live.constants.Attributes;

/**
 * Action to display information for a certain guest as specified in the request parameter guestName
 */
public class GuestInfoAction extends DisplayAction
{
    /**
     * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
     */
    public ActionForward displayPage(CheckedAction.ActionInfo info)
    {
		String guestName = info.getRequestParameter("guestName");
		String groupName = info.cache.getGuest(guestName).getGroupName();
		
		if(groupName == null)
			groupName = Group.UNGROUPED_NAME;
		
		//Need to get this guests info
		ThreadedZVMTasks.QueryGuestInfo thread = 
			new ThreadedZVMTasks.QueryGuestInfo(info.threadInfo, guestName);
		thread.start();
		
		//Also need to get this guests active status.
		ThreadedZVMTasks.ActiveImagesQuery threadActive = new ThreadedZVMTasks.ActiveImagesQuery(info.threadInfo);
		threadActive.start();
		
		// Need to wait for our threads to finish up their tasks, otherwise
		// we won't have anything to display
		try
		{
			thread.join();
			threadActive.join();
		}
		catch(InterruptedException e)
		{}
		

		if(thread.rawResult() instanceof Guest && threadActive.rawResult() instanceof LinkedList)
		{
			// This is the non-error case
			
			// Then thread.rawResult gives us a guest object with all the
			// attributes we're interested in filled in.
			Guest g = (Guest) thread.rawResult();
			info.setRequestAttribute(Attributes.guests.info.name, guestName);
			info.setRequestAttribute(Attributes.guests.info.group, groupName);
			info.setRequestAttribute(Attributes.guests.info.storage, g.getInitMem());
			info.setRequestAttribute(Attributes.guests.info.maxStorage, g.getMaxMem());
			info.setRequestAttribute(Attributes.guests.info.classes, g.getPermissionClasses());
			
			//Set wether guest is on or offline
			boolean foundNameInList = ((LinkedList)threadActive.rawResult()).contains(guestName);
			
			if(foundNameInList) info.setRequestAttribute(Attributes.guests.info.active, "true");
			else info.setRequestAttribute(Attributes.guests.info.active, "false");
			
			return info.findForward(Mappings.guests.info.OK);
		}
		else
		{
			// Stuff broke
			if(thread.rawResult() instanceof Exception)
			{
				// The error was with the image query
			    info.setRequestAttribute(Attributes.error.message, thread.rawResult());
			}
			else
			{
				// The error was with the query active
			    info.setRequestAttribute(Attributes.error.message, threadActive.rawResult());
			}
			
			return info.findForward(Mappings.guests.info.error);
		}
    }
    
}
