/*
 * DeleteSharedMemAction.java
 * Created on August 1, 2005, 12:05 PM
 */
package live.struts.actions;

import live.threads.ThreadedZVMTasks;
import live.constants.Mappings;
import live.constants.Attributes;

import live.threads.ParallelRunner;

import java.util.LinkedList;
import java.util.ListIterator;

import org.apache.struts.action.ActionForward;

/**
 * Action to delete a shared memory segment as specified in the request parameter segName
 */
public class DeleteSharedMemAction extends SwitchedAction
{
    
  /**
    * @see live.struts.actions.SwitchedAction#performAction(live.struts.actions.CheckedAction.ActionInfo)
    */
    public ActionForward performAction(CheckedAction.ActionInfo info)
    {
	//Grab name of segment
	String segName = info.request.getParameter("segName");
	
	//Create a runner that will perform all access removal tasks regardless
	//of wether or not one access removal task fails.
	ParallelRunner delRunner = new ParallelRunner(info.threadInfo, "Deleting shared segment " + segName, 1);
	
	//Need to delete access stmts for all members of this segment
	ThreadedZVMTasks.SharedStorageAccessQueryNameList qThread = new
		ThreadedZVMTasks.SharedStorageAccessQueryNameList(info.threadInfo, segName);
	qThread.startJoinForever();
	
	if(qThread.rawResult() instanceof Exception)
	{
	    info.setRequestAttribute("errorMessage", "Querying access list for shared segment failed.");
	    return info.findForward(Mappings.sharedSegments.delete.error);
	}
	
	LinkedList guests = (LinkedList)qThread.rawResult();
	ListIterator itr = guests.listIterator();
	while(itr.hasNext())
	{
	   ThreadedZVMTasks.SharedStorageAccessRemove accDelThread = 
		   new ThreadedZVMTasks.SharedStorageAccessRemove(info.threadInfo, (String)itr.next(), segName);
	   delRunner.schedule(accDelThread);
	}
	
	ThreadedZVMTasks.SharedStorageDelete delThread = new 
		ThreadedZVMTasks.SharedStorageDelete(info.threadInfo, segName);
	
	delRunner.schedule(delThread);
	delRunner.startJoinTimeout(Util.TIMEOUT_MS);
	
	return info.smartForward(delRunner, Mappings.sharedSegments.list.This);
    }

    /**
    * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
    */
    public ActionForward displayPage(CheckedAction.ActionInfo info)
    {
	String segName = info.getRequestParameter("segName");

	info.setRequestAttribute(Attributes.confirmation.message, "You are about to delete the shared storage segment " + segName + ". Are you sure you wish to proceed?");
	info.setRequestAttribute(Attributes.confirmation.accept_message, "Yes, delete " + segName);

	return info.findForward(Mappings.guests.deletePage.confirm);
    }
    
}
